/*
 * Decompiled with CFR 0.152.
 */
package org.ululatus.sleep.bridges;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.ululatus.sleep.bridges.ExtendingClassLoader;
import org.ululatus.sleep.bridges.InvalidClasspathException;

public class ExtendableClassLoader
extends ClassLoader {
    private Hashtable extending_loaders = new Hashtable();
    private ExtendingClassLoader[] loaders;
    String last_error = "";

    public ExtendableClassLoader() {
    }

    public ExtendableClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected boolean alreadyAdded(String classpath) {
        return this.extending_loaders.containsKey(classpath);
    }

    public boolean extendClasspath(String classpath) throws InvalidClasspathException {
        boolean result = false;
        ExtendingClassLoader ecl = null;
        if (!this.alreadyAdded(this.getCanonicalPath(classpath))) {
            ecl = new ExtendingClassLoader(this, classpath);
        } else {
            result = true;
        }
        if (ecl != null) {
            this.extending_loaders.put(ecl.getClasspath(), ecl);
            this.loaders = this.getLoaders();
            result = true;
        }
        return result;
    }

    public void removeAllPaths() {
        for (int i = 0; i < this.loaders.length; ++i) {
            this.loaders[i].closeFile();
        }
        this.extending_loaders.clear();
    }

    private String getCanonicalPath(String filename) throws InvalidClasspathException {
        String result = null;
        try {
            result = new File(filename).getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new InvalidClasspathException(ioe.toString());
        }
        return result;
    }

    private ExtendingClassLoader[] getLoaders() {
        ExtendingClassLoader[] result = new ExtendingClassLoader[this.extending_loaders.size()];
        result = this.extending_loaders.values().toArray(result);
        return result;
    }

    public Class findClass(String classname) {
        int i;
        Class c = null;
        for (i = 0; i < 1; ++i) {
            try {
                c = Class.forName(classname);
                continue;
            }
            catch (ClassNotFoundException cnf) {
                this.last_error = cnf.toString();
                continue;
            }
            catch (NoClassDefFoundError nc) {
                this.last_error = nc.toString();
                continue;
            }
            catch (LinkageError le) {
                this.last_error = le.toString();
                continue;
            }
            catch (Exception e) {
                this.last_error = e.toString();
            }
        }
        if (c != null) {
            return c;
        }
        for (i = 0; i < this.loaders.length; ++i) {
            c = this.loaders[i].findClass(classname);
            this.last_error = this.loaders[i].getLastError();
            if (c == null) continue;
            return c;
        }
        return c;
    }

    public String getLastError() {
        String err = "";
        err = err + this.last_error;
        this.last_error = "";
        return err;
    }

    public String getLastError$() {
        String err = "";
        for (int i = 0; i < this.loaders.length; ++i) {
            err = this.loaders[i].getLastError();
            if (err.length() <= 0) continue;
            return err;
        }
        return err;
    }

    public byte[] getBytecode(String classname) {
        byte[] bytes = null;
        for (int i = 0; i < this.loaders.length; ++i) {
            bytes = this.loaders[i].loadClassData(classname);
            if (bytes == null) continue;
            return bytes;
        }
        return null;
    }

    public boolean lookup(String classname) {
        byte[] b = this.getBytecode(classname);
        return b != null;
    }

    public URL findResource(String resource) {
        URL u = null;
        for (int i = 0; i < this.loaders.length; ++i) {
            u = this.loaders[i].findResource(resource);
            if (u == null) continue;
            return u;
        }
        return u;
    }

    public ResourceHolder locateResource(String resource) {
        String r = null;
        ExtendingClassLoader l = null;
        for (int i = 0; i < this.loaders.length; ++i) {
            r = this.loaders[i].locateResource(resource);
            if (r == null) continue;
            return new ResourceHolder(l, r);
        }
        return null;
    }

    public byte[] loadResource(String resource) {
        byte[] res = null;
        ResourceHolder holder = this.locateResource(resource);
        if (holder != null) {
            res = holder.ld.loadResource(holder.rsrc);
        }
        return res;
    }

    String[] getClasspathAsArray(String classpaths) {
        String psep = File.pathSeparator;
        StringTokenizer tokenizer = new StringTokenizer(classpaths, psep);
        Vector<String> tokens = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.addElement(tokenizer.nextToken());
        }
        Object[] result = new String[tokens.size()];
        tokens.copyInto(result);
        return result;
    }

    public String[] getClasspaths() {
        String[] result = new String[]{};
        if (!this.extending_loaders.isEmpty()) {
            String[] cp = this.extending_loaders.keySet().toArray(result);
            return cp;
        }
        return result;
    }

    public String getClasspath() {
        String classpath = "";
        String[] patharray = this.getClasspaths();
        for (int i = 0; i < patharray.length; ++i) {
            classpath = classpath + patharray[i];
            if (i == patharray.length - 1) continue;
            classpath = classpath + File.pathSeparator;
        }
        return classpath;
    }

    protected void finalize() throws Throwable {
        for (int i = 0; i < this.loaders.length; ++i) {
            this.loaders[i].closeFile();
        }
        this.extending_loaders.clear();
    }

    class ResourceHolder {
        ExtendingClassLoader ld;
        String rsrc;

        ResourceHolder(ExtendingClassLoader l, String r) {
            this.ld = l;
            this.rsrc = r;
        }
    }
}

