/*
 * Decompiled with CFR 0.152.
 */
package org.ru.amip.tray;

import java.util.Hashtable;
import java.util.Stack;
import org.ru.amip.tray.Init;
import org.ru.amip.tray.Minimize;
import org.ru.amip.tray.Restore;
import org.ru.amip.tray.SetTrayTip;
import org.ru.amip.tray.ShowTrayMessage;
import org.ru.amip.tray.StartFlashIcon;
import org.ru.amip.tray.StopFlashIcon;
import org.ru.amip.tray.Tray;
import rero.gui.GlobalCapabilities;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class TrayLoader
implements Loadable {
    public void scriptLoaded(ScriptInstance script) {
        Hashtable env = script.getScriptEnvironment().getEnvironment();
        env.put("&minimizeToTray", new Minimize());
        env.put("&restoreFromTray", new Restore());
        env.put("&initTray", new Init());
        env.put("&flashIcon", new StartFlashIcon());
        env.put("&stopFlashIcon", new StopFlashIcon());
        env.put("&setTrayOption", new SetTrayOption());
        env.put("&showTrayMessage", new ShowTrayMessage());
        env.put("&setTrayTip", new SetTrayTip());
        env.put("&isFrameMinimized", new IsFrameMinimized());
        env.put("&isFrameVisible", new IsFrameVisible());
        env.put("&isFrameFocused", new IsFrameFocused());
        env.put("&addTrayIcon", new AddTrayIcon());
        env.put("&removeTrayIcon", new RemoveTrayIcon());
    }

    public void scriptUnloaded(ScriptInstance script) {
        Tray t = (Tray)TrayLoader.getTray(script);
        t.removeIcon();
    }

    public static Object getTray(ScriptInstance anInstance) {
        Scalar scalar = anInstance.getScriptVariables().getGlobalVariables().getScalar("%GLOBAL");
        return scalar.getHash().getAt(SleepUtils.getScalar((String)"TRAY_INSTANCE")).objectValue();
    }

    private static class IsFrameFocused
    implements Function {
        private IsFrameFocused() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            if (GlobalCapabilities.frame.isFocused()) {
                return SleepUtils.getScalar((int)1);
            }
            return SleepUtils.getScalar((int)0);
        }
    }

    private static class IsFrameVisible
    implements Function {
        private IsFrameVisible() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            if (GlobalCapabilities.frame.isVisible()) {
                return SleepUtils.getScalar((int)1);
            }
            return SleepUtils.getScalar((int)0);
        }
    }

    private static class IsFrameMinimized
    implements Function {
        private IsFrameMinimized() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            if (GlobalCapabilities.frame.getState() == 1) {
                return SleepUtils.getScalar((int)1);
            }
            return SleepUtils.getScalar((int)0);
        }
    }

    private static class RemoveTrayIcon
    implements Function {
        private RemoveTrayIcon() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            Tray t = (Tray)TrayLoader.getTray(script);
            t.removeIcon();
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class AddTrayIcon
    implements Function {
        private AddTrayIcon() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            Tray t = (Tray)TrayLoader.getTray(script);
            t.addIcon();
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class SetTrayOption
    implements Function {
        private SetTrayOption() {
        }

        public Scalar evaluate(String functionName, ScriptInstance anInstance, Stack passedInLocals) {
            Tray t = (Tray)TrayLoader.getTray(anInstance);
            String key = BridgeUtilities.getString((Stack)passedInLocals, null);
            String value = BridgeUtilities.getString((Stack)passedInLocals, (String)"");
            if (key != null) {
                t.setOption(key, value);
            }
            return SleepUtils.getEmptyScalar();
        }
    }
}

