/*
 * Decompiled with CFR 0.152.
 */
package org.ru.amip.tray;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jdesktop.jdic.tray.SystemTray;
import org.jdesktop.jdic.tray.TrayIcon;
import rero.gui.GlobalCapabilities;
import rero.gui.SessionManager;

public class Tray {
    SystemTray tray = SystemTray.getDefaultSystemTray();
    TrayIcon ti;
    private JFrame ourFrame;
    boolean intray = false;
    private Thread ourFlashThread;
    private ImageIcon ourIcon;
    private ImageIcon ourTransIcon;
    private HashMap options = new HashMap();

    public Tray(String iconfile, String transfile, boolean autoresize) {
        this.ourFrame = GlobalCapabilities.frame;
        this.ourFrame.addWindowStateListener(new WindowStateListener(){

            public void windowStateChanged(WindowEvent e) {
                int newState = e.getNewState();
                if (newState == 1) {
                    Tray.this.sendToTray();
                } else {
                    Tray.this.stopFlashIcon();
                }
            }
        });
        this.ourFrame.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                Tray.this.stopFlashIcon();
            }

            public void windowLostFocus(WindowEvent e) {
            }
        });
        if (Integer.parseInt(System.getProperty("java.version").substring(2, 3)) >= 5) {
            System.setProperty("javax.swing.adjustPopupLocationToFit", "false");
        }
        JPopupMenu menu = new JPopupMenu("jIRCii Menu");
        JMenuItem menuItem = new JMenuItem("Restore");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Tray.this.restoreFromTray();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Exit");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SessionManager.getGlobalCapabilities().QuitClient();
            }
        });
        menu.add(menuItem);
        this.ourIcon = new ImageIcon(iconfile);
        this.ourTransIcon = new ImageIcon(transfile);
        this.ti = new TrayIcon((Icon)this.ourIcon, "jIRCii", menu);
        if (autoresize) {
            this.ti.setIconAutoSize(true);
        } else {
            this.ti.setIconAutoSize(false);
        }
        this.ti.addBalloonActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Tray.this.restoreFromTray();
            }
        });
        this.ti.addActionListener(new ActionListener(){
            long oldwhen;
            int clicks = 0;

            public void actionPerformed(ActionEvent e) {
                long when = e.getWhen();
                if (when - this.oldwhen < (long)Tray.this.getIntOption("clickinterval", 1000) || this.oldwhen == 0L) {
                    ++this.clicks;
                }
                if (this.clicks < Tray.this.getIntOption("clicks", 2)) {
                    this.oldwhen = when;
                    return;
                }
                this.oldwhen = 0L;
                this.clicks = 0;
                Tray.this.restoreFromTray();
            }
        });
    }

    public void restoreFromTray() {
        this.ourFrame.setVisible(true);
        if (!this.isOption("keepintray")) {
            this.removeIcon();
        }
        this.ourFrame.setState(0);
        this.stopFlashIcon();
    }

    public void sendToTray() {
        this.addIcon();
        if (this.isOption("hideframe")) {
            this.ourFrame.setVisible(false);
        }
    }

    protected String getClassName(Object o) {
        String classString = o.getClass().getName();
        int dotIndex = classString.lastIndexOf(".");
        return classString.substring(dotIndex + 1);
    }

    public void addIcon() {
        if (!this.intray) {
            this.tray.addTrayIcon(this.ti);
            this.intray = true;
        }
    }

    public void removeIcon() {
        if (this.intray) {
            this.tray.removeTrayIcon(this.ti);
            this.intray = false;
        }
    }

    public void flashIcon() {
        final int interval = this.getIntOption("flashinterval", 500);
        if (this.intray && this.ourFlashThread == null) {
            this.ourFlashThread = new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        Tray.this.ti.setIcon((Icon)Tray.this.ourTransIcon);
                        try {
                            Thread.sleep(interval);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        Tray.this.ti.setIcon((Icon)Tray.this.ourIcon);
                        try {
                            Thread.sleep(interval);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    Tray.this.ti.setIcon((Icon)Tray.this.ourIcon);
                }
            });
            this.ourFlashThread.start();
        }
    }

    public void stopFlashIcon() {
        if (this.ourFlashThread != null) {
            this.ourFlashThread.interrupt();
            this.ourFlashThread = null;
        }
    }

    public void setOption(String key, String value) {
        key = key.toLowerCase();
        this.options.put(key, value);
    }

    public String getOption(String key, String defult) {
        if (this.options.containsKey(key = key.toLowerCase()) && !"".equals(this.options.get(key))) {
            return (String)this.options.get(key);
        }
        return defult;
    }

    public int getIntOption(String key, int defult) {
        String value = this.getOption(key, Integer.toString(defult));
        return Integer.parseInt(value);
    }

    public boolean isOption(String key) {
        String value = this.getOption(key, "false");
        return "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    public void showTrayMessage(String title, String message, int mode) {
        if (this.intray) {
            this.ti.displayMessage(title, message, mode);
        }
    }

    public void setTrayTip(String tip) {
        this.ti.setToolTip(tip);
    }
}

