/*
 * Decompiled with CFR 0.152.
 */
package text.wrapped;

import java.util.LinkedList;
import java.util.ListIterator;
import text.AttributedString;
import text.AttributedText;
import text.wrapped.WrappedContainer;

public class WrappedNames
extends WrappedContainer {
    protected AttributedText[] rawData;
    protected double percentage;
    protected String[] users;

    public WrappedNames(String text, String[] _users, double _percentage) {
        super(text);
        this.users = _users;
        this.calculateAttributes();
        this.percentage = _percentage;
    }

    public void calculateAttributes() {
        this.rawData = new AttributedText[this.users.length];
        for (int x = 0; x < this.users.length; ++x) {
            AttributedString temp = AttributedString.CreateAttributedString(this.users[x]);
            temp.assignWidths();
            this.rawData[x] = temp.getAttributedText();
        }
    }

    public void touch(int size) {
        int width = (int)((double)size * this.percentage);
        if (width < this.maxSize && width > this.minSize) {
            return;
        }
        this.wrapped = this.wrapNames(width);
        this.determineBounds(width);
    }

    public void reset() {
        super.reset();
        this.calculateAttributes();
    }

    public AttributedText[] wrapNames(int width) {
        AttributedText head;
        LinkedList<AttributedText> values = new LinkedList<AttributedText>();
        AttributedText temp = head = this.rawData[0].cloneList();
        while (temp.next != null) {
            temp = temp.next;
        }
        int current = this.rawData[0].getWidth();
        for (int x = 1; x < this.rawData.length; ++x) {
            if ((current += this.rawData[x].getWidth()) > width) {
                values.add(head);
                head = this.rawData[x].cloneList();
                current = head.getWidth();
                temp = head;
                while (temp.next != null) {
                    temp = temp.next;
                }
                continue;
            }
            temp.next = this.rawData[x].cloneList();
            while (temp.next != null) {
                temp = temp.next;
            }
        }
        values.add(head);
        AttributedText[] returnValue = new AttributedText[values.size()];
        int x = values.size() - 1;
        ListIterator i = values.listIterator();
        while (i.hasNext()) {
            returnValue[x] = (AttributedText)i.next();
            --x;
        }
        return returnValue;
    }
}

