/*
 * Decompiled with CFR 0.152.
 */
package text.wrapped;

import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import text.AttributedText;
import text.TextSource;
import text.wrapped.SelectionSpace;
import text.wrapped.WrappedContainer;
import text.wrapped.WrappedData;

public class WrappedDisplayComponent
extends JComponent
implements ChangeListener {
    protected WrappedData data;

    public WrappedDisplayComponent() {
        this.setOpaque(false);
        this.setDoubleBuffered(false);
    }

    public void setWrappedData(WrappedData _data) {
        this.data = _data;
    }

    public void stateChanged(ChangeEvent e) {
        this.repaint();
    }

    public void paint(Graphics g) {
        TextSource.initGraphics(g);
        WrappedContainer text = this.data.getCurrentText();
        this.data.setExtent((this.getHeight() - 5) / (TextSource.fontMetrics.getHeight() * 3));
        if (text == null) {
            return;
        }
        int checkY = g.getClipBounds().y - 10;
        int checkH = checkY + g.getClipBounds().height + 20;
        int width = super.getWidth();
        int height = super.getHeight();
        g.setFont(TextSource.clientFont);
        int baseline = height - 5;
        WrappedContainer head = text;
        if (this.data.getSelection() != null) {
            this.data.getSelection().clear();
        }
        while (head != null && baseline > 0) {
            head.touch(width);
            AttributedText[] strings = head.getWrappedText();
            for (int x = 0; x < strings.length && baseline > 0; baseline -= TextSource.fontMetrics.getHeight() + 2, ++x) {
                if (baseline > checkH || baseline < checkY) continue;
                TextSource.drawBackground(g, strings[x], 0, baseline);
                this.drawSelection(g, strings[x], baseline, x == 0);
                TextSource.drawForeground(g, strings[x], 0, baseline);
            }
            head = head.next();
        }
    }

    public void drawSelection(Graphics g, AttributedText text, int baseline, boolean beginning) {
        if (this.data.getSelection() == null) {
            return;
        }
        SelectionSpace select = this.data.getSelection();
        g.setColor(UIManager.getColor("TextField.selectionBackground"));
        if (select.isOnlyLine(baseline)) {
            int indexStart = text.getRange(0, select.getSingleStart()).length();
            int indexStop = text.getRange(0, select.getSingleEnd()).length();
            String stext = text.getText();
            int height = TextSource.fontMetrics.getHeight();
            int start = TextSource.fontMetrics.stringWidth(stext.substring(0, indexStart));
            int stop = TextSource.fontMetrics.stringWidth(stext.substring(0, indexStop));
            select.append(stext.substring(indexStart, indexStop));
            g.fillRect(start, baseline - height + 2, stop - start, height + 2);
        } else if (select.isStartLine(baseline)) {
            if (beginning) {
                select.touch();
            }
            String stext = text.getRange(0, select.getSelectionStart());
            int height = TextSource.fontMetrics.getHeight();
            int width = TextSource.fontMetrics.stringWidth(stext);
            String temps = text.getText();
            stext = temps.substring(stext.length(), temps.length());
            select.append(stext);
            g.fillRect(width, baseline - height + 2, text.getWidth() - width, height + 2);
        } else if (select.isEndLine(baseline)) {
            if (beginning) {
                select.touch();
            }
            int height = TextSource.fontMetrics.getHeight();
            int width = TextSource.fontMetrics.stringWidth(text.getRange(0, select.getSelectionEnd()));
            if (text.isIndent()) {
                String stext = text.next.getRange(0, select.getSelectionEnd());
                select.append(stext);
                select.append(" ");
            } else {
                String stext = text.getRange(0, select.getSelectionEnd());
                select.append(stext);
            }
            g.fillRect(0, baseline - height + 2, width, height + 2);
        } else if (select.isSelectedLine(baseline)) {
            if (beginning) {
                select.touch();
            }
            int height = TextSource.fontMetrics.getHeight();
            g.fillRect(0, baseline - height + 2, text.getWidth(), height + 2);
            if (text.isIndent()) {
                text = text.next;
                select.append(text.getText());
                select.append(" ");
            } else {
                select.append(text.getText());
            }
        }
    }
}

