/*
 * Decompiled with CFR 0.152.
 */
package text.wrapped;

import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rero.config.ClientState;
import text.AttributedText;
import text.TextSource;
import text.wrapped.SelectionSpace;
import text.wrapped.WrappedContainer;
import text.wrapped.WrappedObject;

public class WrappedData
implements BoundedRangeModel {
    private static int WRAP_TOLERANCE = 2000;
    private static int WRAP_TO = 1000;
    protected WrappedContainer last = null;
    protected WrappedContainer text = null;
    protected WrappedContainer head = null;
    protected int tempMax = 1;
    protected int maxValue = 1;
    protected int currentValue = 0;
    protected boolean adjusting = false;
    protected LinkedList listeners = new LinkedList();
    protected ChangeEvent event;
    protected int extent = 1;
    protected int tempExtent = 1;
    protected Runnable changeEventTask = new Runnable(){

        public void run() {
            WrappedData.this.fireChangeEvent();
        }
    };
    protected SelectionSpace selection;

    public WrappedData() {
        this.event = new ChangeEvent(this);
    }

    public ListIterator find(String text) {
        LinkedList<Integer> values = new LinkedList<Integer>();
        int x = 0;
        WrappedContainer temp = this.last;
        while (temp != null) {
            if (temp.getText().toUpperCase().indexOf(text.toUpperCase()) > -1) {
                values.add(new Integer(x));
            }
            ++x;
            temp = temp.prev;
        }
        ListIterator i = values.listIterator();
        while (i.hasNext()) {
            int tempzz = (Integer)i.next();
            if (tempzz < this.currentValue) continue;
            i.previous();
            break;
        }
        return i;
    }

    public void dirty() {
        for (WrappedContainer temp = this.last; temp != null; temp = temp.previous()) {
            temp.reset();
        }
    }

    public void reset() {
        this.tempMax = 1;
        this.maxValue = 1;
        this.currentValue = 0;
        this.extent = 1;
        this.tempExtent = 1;
        this.head = null;
        this.last = null;
        this.text = null;
        this.fireChangeEvent();
    }

    public WrappedContainer getCurrentText() {
        return this.text;
    }

    public WrappedObject getTokenAt(int height, int pixelx, int pixely) {
        int baseline = height - 5;
        int lineno = 0;
        int desired = TextSource.translateToLineNumber(pixely);
        for (WrappedContainer head = this.text; head != null && baseline > 0; head = head.next()) {
            AttributedText[] strings = head.getWrappedText();
            for (int x = 0; strings != null && x < strings.length && baseline > 0; baseline -= TextSource.fontMetrics.getHeight() + 2, ++x) {
                if (pixely >= baseline - TextSource.fontMetrics.getHeight() - 2) {
                    return new WrappedObject(head.getText(), head.getTokenAt(strings[x], pixelx));
                }
                ++lineno;
            }
        }
        return null;
    }

    public WrappedObject getAttributesAt(int height, int pixelx, int pixely) {
        int baseline = height - 5;
        int lineno = 0;
        int desired = TextSource.translateToLineNumber(pixely);
        for (WrappedContainer head = this.text; head != null && baseline > 0; head = head.next()) {
            AttributedText[] strings = head.getWrappedText();
            for (int x = 0; x < strings.length && baseline > 0; baseline -= TextSource.fontMetrics.getHeight() + 2, ++x) {
                if (pixely >= baseline - TextSource.fontMetrics.getHeight() - 2) {
                    return new WrappedObject(head.getText(), head.getAttributedTextAt(strings[x], pixelx));
                }
                ++lineno;
            }
        }
        return null;
    }

    public void fireChangeEvent() {
        ListIterator i = this.listeners.listIterator();
        while (i.hasNext()) {
            ChangeListener temp = (ChangeListener)i.next();
            temp.stateChanged(this.event);
        }
    }

    public void addChangeListener(ChangeListener x) {
        this.listeners.add(x);
    }

    public void removeChangeListener(ChangeListener x) {
        this.listeners.remove(x);
    }

    public void addText(WrappedContainer container) {
        boolean jump = true;
        if (this.head == null) {
            this.head = container;
            this.text = container;
            this.last = container;
        } else {
            container.setNext(this.head);
            this.head.setPrevious(container);
            this.head = container;
            if (this.text.previous() != this.head) {
                ++this.maxValue;
            } else if (!this.getValueIsAdjusting()) {
                this.text = container;
                if (this.maxValue > WRAP_TOLERANCE) {
                    while (this.maxValue > WRAP_TO && this.last.hasPrevious()) {
                        this.last = this.last.previous();
                        --this.maxValue;
                    }
                    this.last.setNext(null);
                }
                this.currentValue = this.maxValue++;
            } else {
                ++this.tempMax;
            }
        }
        SwingUtilities.invokeLater(this.changeEventTask);
    }

    public int getExtent() {
        return 1;
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public int getMinimum() {
        return 0;
    }

    public int getValue() {
        return this.currentValue;
    }

    public boolean getValueIsAdjusting() {
        return this.adjusting;
    }

    public void setExtent(int x) {
        this.extent = x;
    }

    public void setMaximum(int x) {
    }

    public void setMinimum(int x) {
    }

    public void setRangeProperties(int newValue, int extent, int min, int max, boolean adjusting) {
    }

    public void setValue(int newValue) {
        if (this.head == null) {
            return;
        }
        if (this.currentValue > newValue) {
            while (this.currentValue > newValue && this.text.hasNext()) {
                this.text = this.text.next();
                --this.currentValue;
            }
        } else if (this.currentValue < newValue) {
            while (this.currentValue < newValue && this.text.hasPrevious()) {
                this.text = this.text.previous();
                ++this.currentValue;
            }
        }
        this.currentValue = newValue;
        if (this.currentValue >= this.maxValue) {
            this.currentValue = this.maxValue - 1;
        }
        if (this.currentValue < 0) {
            this.currentValue = 0;
        }
        this.fireChangeEvent();
    }

    public void setValueIsAdjusting(boolean b) {
        this.adjusting = b;
        if (!b && this.tempMax > this.maxValue) {
            this.maxValue = this.tempMax;
        } else {
            this.tempMax = this.maxValue;
        }
    }

    public void setSelection(SelectionSpace select) {
        this.selection = select;
    }

    public SelectionSpace getSelection() {
        return this.selection;
    }

    static {
        WRAP_TOLERANCE = ClientState.getClientState().getInteger("ui.buffersize", 2000);
        WRAP_TO = WRAP_TOLERANCE / 2;
    }
}

