/*
 * Decompiled with CFR 0.152.
 */
package text.wrapped;

import java.util.LinkedList;
import java.util.ListIterator;
import rero.util.TokenizedString;
import text.AttributedString;
import text.AttributedText;
import text.TextSource;

public class WrappedContainer {
    protected int maxSize;
    protected int minSize;
    protected WrappedContainer next = null;
    protected WrappedContainer prev = null;
    protected AttributedString text;
    protected AttributedText[] wrapped;

    public WrappedContainer(String input) {
        this.text = AttributedString.CreateAttributedString(input);
    }

    public WrappedContainer next() {
        return this.next;
    }

    public WrappedContainer previous() {
        return this.prev;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public boolean hasPrevious() {
        return this.prev != null;
    }

    public void setNext(WrappedContainer n) {
        this.next = n;
    }

    public void setPrevious(WrappedContainer p) {
        this.prev = p;
    }

    public void touch(int size) {
        if (size >= this.minSize && size <= this.maxSize) {
            return;
        }
        this.wrapped = WrappedContainer.wrap(this.text, size);
        this.determineBounds(size);
    }

    public void reset() {
        this.minSize = 786432;
        this.maxSize = 0;
    }

    protected void determineBounds(int size) {
        this.minSize = 0;
        this.maxSize = Integer.MAX_VALUE;
        for (int x = 0; x < this.wrapped.length; ++x) {
            int width = 0;
            AttributedText temp = this.wrapped[x];
            while (temp != null) {
                width += temp.width;
                temp = temp.next;
            }
            if (width <= this.minSize) continue;
            this.minSize = width;
        }
        this.maxSize = size + 50;
    }

    public AttributedText[] getWrappedText() {
        return this.wrapped;
    }

    public String getText() {
        return this.text.getText();
    }

    public String getTokenAt(AttributedText lineno, int pixelx) {
        if (lineno.isIndent()) {
            pixelx -= lineno.width;
            lineno = lineno.next;
        }
        String temp = lineno.getText();
        TokenizedString tokens = new TokenizedString(temp, " ");
        for (int x = 0; x < tokens.getTotalTokens() + 1; ++x) {
            int z;
            if (TextSource.fontMetrics.stringWidth(tokens.getTokenTo(x)) <= pixelx) continue;
            String rv = x > 0 ? tokens.getToken(x - 1) : tokens.getToken(0);
            if (this.text.getTokens().isToken(rv)) {
                return rv;
            }
            for (z = 0; z < this.text.getTokens().getTotalTokens(); ++z) {
                if (rv.length() >= this.text.getTokens().getToken(z).length() || !this.text.getTokens().getToken(z).substring(0, rv.length()).equals(rv)) continue;
                return this.text.getTokens().getToken(z);
            }
            for (z = 0; z < this.text.getTokens().getTotalTokens(); ++z) {
                if (rv.length() >= this.text.getTokens().getToken(z).length() || this.text.getTokens().getToken(z).indexOf(rv) <= -1) continue;
                return this.text.getTokens().getToken(z);
            }
            return rv;
        }
        return null;
    }

    public AttributedText getAttributedTextAt(AttributedText line, int pixelx) {
        int width = 0;
        while (line != null && width + line.width < pixelx) {
            width += line.width;
            line = line.next;
        }
        return line;
    }

    public static AttributedText[] wrap(AttributedString textData, int maxWidth) {
        AttributedText head;
        if (maxWidth < 100) {
            return new AttributedText[0];
        }
        TokenizedString tokens = textData.getTokens();
        LinkedList<AttributedText> data = new LinkedList<AttributedText>();
        String text = textData.getText();
        String current = "";
        int tokenNo = 0;
        int start = 0;
        int oldlength = 0;
        int indentlen = 0;
        String indent = "";
        int totalWidth = 0;
        while (tokenNo <= tokens.getTotalTokens()) {
            if (totalWidth >= maxWidth) {
                int size = TextSource.fontMetrics.stringWidth(tokens.getToken(tokenNo - 1)) + indentlen;
                if (start == oldlength && size < maxWidth) {
                    oldlength = current.length();
                    current = tokens.getTokenTo(++tokenNo);
                    totalWidth = TextSource.fontMetrics.stringWidth(text.substring(start, current.length())) + indentlen;
                    continue;
                }
                if (size >= maxWidth) {
                    int y;
                    for (y = start + 1; y < current.length() && TextSource.fontMetrics.stringWidth(text.substring(start, y)) + indentlen < maxWidth; ++y) {
                    }
                    --y;
                    if (indent.length() > 0) {
                        head = new AttributedText();
                        head.text = indent;
                        head.width = indentlen;
                        head.next = textData.substring(start, y);
                        head.setIndent();
                    } else {
                        head = textData.substring(start, y);
                    }
                    data.add(head);
                    indent = "   ";
                    indentlen = TextSource.fontMetrics.stringWidth("   ");
                    for (start = y; start < text.length() && text.charAt(start) == ' '; ++start) {
                    }
                    oldlength = start;
                    totalWidth = TextSource.fontMetrics.stringWidth(text.substring(start, current.length())) + indentlen;
                    continue;
                }
                if (indent.length() > 0) {
                    head = new AttributedText();
                    head.text = indent;
                    head.width = indentlen;
                    head.next = textData.substring(start, oldlength);
                    head.setIndent();
                } else {
                    head = textData.substring(start, oldlength);
                }
                data.add(head);
                indent = "   ";
                indentlen = TextSource.fontMetrics.stringWidth("   ");
                for (start = oldlength; start < text.length() && text.charAt(start) == ' '; ++start) {
                }
                oldlength = start;
                continue;
            }
            oldlength = current.length();
            current = tokens.getTokenTo(++tokenNo);
            totalWidth = TextSource.fontMetrics.stringWidth(text.substring(start, current.length())) + indentlen;
        }
        if (start < text.length()) {
            if (indent.length() > 0) {
                head = new AttributedText();
                head.text = indent;
                head.width = indentlen;
                head.next = textData.substring(start, oldlength);
                head.setIndent();
            } else {
                head = textData.substring(start, oldlength);
            }
            data.add(head);
        }
        AttributedText[] returnValue = new AttributedText[data.size()];
        int x = data.size() - 1;
        ListIterator i = data.listIterator();
        while (i.hasNext()) {
            returnValue[x] = (AttributedText)i.next();
            --x;
        }
        return returnValue;
    }
}

