/*
 * Decompiled with CFR 0.152.
 */
package text.wrapped;

import java.awt.Point;
import java.awt.Rectangle;
import text.TextSource;

public class SelectionSpace {
    protected boolean ready = false;
    protected int origin_x;
    protected int origin_y;
    protected int start_sel;
    protected int end_sel;
    protected int x;
    protected int y;
    boolean flipped;
    protected int lineStart = 0;
    protected int lineEnd = 0;
    protected StringBuffer selection;
    protected Rectangle changed;

    public SelectionSpace(Point p) {
        this.origin_x = (int)p.getX();
        this.origin_y = (int)p.getY();
        this.changed = new Rectangle(0, this.origin_y - (TextSource.fontMetrics.getHeight() + 2) * 1, 2048, (TextSource.fontMetrics.getHeight() + 2) * 2);
        this.ready = false;
    }

    public void clear() {
        this.selection = new StringBuffer();
    }

    public void append(String text) {
        if (text.length() > 0) {
            this.selection.insert(0, text);
        }
    }

    public void touch() {
        if (this.selection.length() > 0) {
            this.append("\n");
        }
    }

    public String getSelectedText() {
        if (this.selection != null) {
            return this.selection.toString();
        }
        return null;
    }

    protected int translateToLineNumber(int pixely) {
        int height = TextSource.fontMetrics.getHeight() + 2;
        return ((pixely -= 5) - pixely % height) / height;
    }

    protected int translateToPixel(int lineno) {
        return lineno * (TextSource.fontMetrics.getHeight() + 2) + 5;
    }

    public boolean isSelectedLine(int y) {
        int temp = this.translateToLineNumber(y);
        return this.ready && temp >= this.lineStart && temp <= this.lineEnd;
    }

    public boolean isOnlyLine(int y) {
        return this.isStartLine(y) && this.isEndLine(y);
    }

    public boolean isEndLine(int y) {
        int temp = this.translateToLineNumber(y);
        return this.ready && temp == this.lineEnd;
    }

    public boolean isStartLine(int y) {
        int temp = this.translateToLineNumber(y);
        return this.ready && temp == this.lineStart;
    }

    public int getSingleStart() {
        if (this.start_sel < this.end_sel) {
            return this.start_sel;
        }
        return this.end_sel;
    }

    public int getSingleEnd() {
        if (this.start_sel < this.end_sel) {
            return this.end_sel;
        }
        return this.start_sel;
    }

    public int getSelectionStart() {
        return this.start_sel;
    }

    public int getSelectionEnd() {
        return this.end_sel;
    }

    public Rectangle getChangedArea() {
        return this.changed;
    }

    public void growSelection(Point p) {
        int end;
        this.ready = true;
        this.x = (int)p.getX();
        this.y = (int)p.getY();
        this.flipped = this.y < this.origin_y;
        if (this.flipped) {
            this.lineStart = this.translateToLineNumber(this.y);
            this.lineEnd = this.translateToLineNumber(this.origin_y);
        } else {
            this.lineStart = this.translateToLineNumber(this.origin_y);
            this.lineEnd = this.translateToLineNumber(this.y);
        }
        if (this.flipped) {
            this.start_sel = this.x;
            this.end_sel = this.origin_x;
        } else {
            this.start_sel = this.origin_x;
            this.end_sel = this.x;
        }
        int start = this.translateToPixel(this.lineStart - 1);
        if ((double)start > this.changed.getY()) {
            start = (int)this.changed.getY();
        }
        if ((double)(end = this.translateToPixel(this.lineEnd + 2) - start) < this.changed.getHeight()) {
            end = (int)this.changed.getHeight();
        }
        this.changed.setBounds(0, start, 2048, end);
    }
}

