/*
 * Decompiled with CFR 0.152.
 */
package text.list;

import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.event.MouseInputAdapter;
import text.ListDisplay;
import text.TextSource;
import text.list.ListData;
import text.list.ListElement;

public class ListSelectionSpace
extends MouseInputAdapter {
    protected ListData data;
    protected ListDisplay display;
    protected int start;

    public ListSelectionSpace(ListDisplay _display, ListData _data) {
        this.data = _data;
        this.display = _display;
    }

    public void clearSelections() {
        Iterator i = this.data.dataIterator();
        while (i.hasNext()) {
            ListElement element = (ListElement)i.next();
            element.setSelected(false);
        }
    }

    public ListElement getSelectedElement() {
        ListElement temp = this.data.getElementAtLocation(this.start);
        if (temp != null && temp.isSelected()) {
            return temp;
        }
        return null;
    }

    public LinkedList getSelectedElements() {
        LinkedList<ListElement> selection = new LinkedList<ListElement>();
        Iterator i = this.data.dataIterator();
        while (i.hasNext()) {
            ListElement element = (ListElement)i.next();
            if (!element.isSelected()) continue;
            selection.add(element);
        }
        return selection;
    }

    public void mousePressed(MouseEvent ev) {
        if (!(ev.getButton() != 1 || ev.isPopupTrigger() || ev.isShiftDown() && ev.isControlDown())) {
            if ((ev.getModifiers() & 2) == 2 || (ev.getModifiers() & 8) == 8) {
                ListElement temp = this.data.getElementAtLocation(ev.getY());
                if (temp != null) {
                    if (!temp.isSelected()) {
                        this.start = ev.getY();
                    }
                    temp.setSelected(!temp.isSelected());
                    this.display.repaint();
                }
            } else if ((ev.getModifiers() & 1) == 1) {
                this.selectRange(ev);
            } else {
                this.start = ev.getY();
                this.clearSelections();
                this.setSelectedAt(this.start, true);
                this.display.repaint();
            }
        }
    }

    public void mouseReleased(MouseEvent ev) {
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseDragged(MouseEvent ev) {
        if (ev.getButton() == 16 || (ev.getModifiers() & 0x10) == 16) {
            this.selectRange(ev);
        }
    }

    private void selectRange(MouseEvent ev) {
        this.clearSelections();
        boolean repaint = false;
        int _height = TextSource.fontMetrics.getHeight() + 2;
        if (this.start < ev.getY()) {
            for (int temp = this.start; temp < ev.getY(); temp += _height) {
                this.setSelectedAt(temp, true);
            }
        } else {
            for (int temp = ev.getY(); temp < this.start; temp += _height) {
                this.setSelectedAt(temp, true);
            }
            this.setSelectedAt(this.start, true);
        }
        this.display.repaint();
    }

    public boolean setSelectedAt(int pixely, boolean selected) {
        ListElement temp = this.data.getElementAtLocation(pixely);
        if (temp != null && temp.isSelected() != selected) {
            temp.setSelected(selected);
            return true;
        }
        return false;
    }

    public int translateToLineNumber(int pixely) {
        int _height = TextSource.fontMetrics.getHeight() + 2;
        int lineNo = (pixely - pixely % _height) / _height + this.data.getValue();
        return lineNo;
    }
}

