/*
 * Decompiled with CFR 0.152.
 */
package text.list;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import text.TextSource;
import text.list.ListData;
import text.list.ListElement;

public class ListDisplayComponent
extends JComponent
implements ChangeListener,
ClientStateListener {
    protected ListData data;
    protected String test_string = "";
    private static final String widthstring = "1234567890123456789012345678901234567890123456789012345678901234567890";

    public ListDisplayComponent() {
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        ClientState.getClientState().addClientStateListener("listbox.width", this);
        this.propertyChanged(null, null);
    }

    public void installDataSource(ListData _data) {
        this.data = _data;
    }

    public void propertyChanged(String a, String b) {
        this.test_string = widthstring.substring(0, ClientState.getClientState().getInteger("listbox.width", 10));
        this.revalidate();
    }

    public void stateChanged(ChangeEvent e) {
        this.repaint();
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = TextSource.fontMetrics;
        return new Dimension(fm.stringWidth(this.test_string) + 2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        TextSource.initGraphics(g);
        this.data.setExtent(this.getHeight() / (TextSource.fontMetrics.getHeight() + 2));
        int checkY = g.getClipBounds().y - 10;
        int checkH = checkY + g.getClipBounds().height + 20;
        int width = super.getWidth();
        int height = super.getHeight();
        g.setFont(TextSource.clientFont);
        Object object = this.data.getSynchronizationKeyOuter();
        synchronized (object) {
            Object object2 = this.data.getSynchronizationKeyInner();
            synchronized (object2) {
                ListElement head = this.data.head();
                for (int baseline = TextSource.fontMetrics.getHeight() - 2; head != null && baseline < height; baseline += TextSource.fontMetrics.getHeight() + 2) {
                    if (baseline <= checkH && baseline >= checkY) {
                        if (head.isSelected()) {
                            g.setColor(UIManager.getColor("TextField.selectionBackground"));
                            int txtheight = TextSource.fontMetrics.getHeight();
                            g.fillRect(0, baseline - txtheight + 2, width, txtheight + 2);
                        }
                        TextSource.drawText(g, head.getAttributedText(), 2, baseline);
                    }
                    head = this.data.next();
                }
            }
        }
    }
}

