/*
 * Decompiled with CFR 0.152.
 */
package text.list;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import text.TextSource;
import text.list.ListElement;

public abstract class ListData
implements BoundedRangeModel {
    protected ChangeEvent event = new ChangeEvent(this);
    protected LinkedList listeners = new LinkedList();
    protected int currentValue = 0;
    protected boolean adjusting = false;
    protected int extent = 1;

    public ListElement getElementAtLocation(int pixely) {
        int _height = TextSource.fontMetrics.getHeight() + 2;
        int lineNo = (pixely - pixely % _height) / _height + this.currentValue;
        return this.getElementAt(lineNo);
    }

    public void dirty() {
    }

    public abstract int getSize();

    public abstract ListElement head();

    public abstract ListElement next();

    public abstract ListElement getElementAt(int var1);

    public abstract Iterator dataIterator();

    public Object getSynchronizationKeyOuter() {
        return null;
    }

    public Object getSynchronizationKeyInner() {
        return null;
    }

    public void fireChangeEvent() {
        ListIterator i = this.listeners.listIterator();
        while (i.hasNext()) {
            ChangeListener temp = (ChangeListener)i.next();
            temp.stateChanged(this.event);
        }
    }

    public void addChangeListener(ChangeListener x) {
        this.listeners.add(x);
    }

    public void removeChangeListener(ChangeListener x) {
        this.listeners.remove(x);
    }

    public int getExtent() {
        return this.extent;
    }

    public int getMaximum() {
        return this.getSize();
    }

    public int getMinimum() {
        return 0;
    }

    public int getValue() {
        if (this.currentValue + this.extent > this.getSize()) {
            this.currentValue = this.getSize() - this.extent;
        }
        if (this.getSize() < this.extent) {
            this.currentValue = 0;
        }
        if (this.currentValue < this.getSize()) {
            return this.currentValue;
        }
        this.currentValue = this.getSize() - 1;
        return this.currentValue;
    }

    public boolean getValueIsAdjusting() {
        return this.adjusting;
    }

    public void setExtent(int x) {
        this.extent = x;
    }

    public void setMaximum(int x) {
    }

    public void setMinimum(int x) {
    }

    public void setRangeProperties(int newValue, int extent, int min, int max, boolean adjusting) {
    }

    public void setValue(int newValue) {
        this.currentValue = newValue < 0 ? 0 : (newValue < this.getSize() ? newValue : this.getSize() - 1);
        this.fireChangeEvent();
    }

    public void setValueIsAdjusting(boolean b) {
        this.adjusting = b;
    }
}

