/*
 * Decompiled with CFR 0.152.
 */
package text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.MouseInputListener;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.SessionManager;
import rero.gui.script.WindowAreaClickListener;
import text.AttributedText;
import text.FindDialog;
import text.ModifyColorMapDialog;
import text.event.ClickEvent;
import text.event.ClickListener;
import text.wrapped.SelectionSpace;
import text.wrapped.WrappedContainer;
import text.wrapped.WrappedData;
import text.wrapped.WrappedDisplayComponent;
import text.wrapped.WrappedNames;
import text.wrapped.WrappedObject;

public class WrappedDisplay
extends JComponent
implements MouseWheelListener,
MouseInputListener,
ClientStateListener {
    protected WrappedDisplayComponent display;
    protected JScrollBar scroller;
    protected WrappedData data;
    protected FindDialog search = null;
    protected LinkedList listeners = new LinkedList();

    public void showSearchDialog(String title) {
        if (this.search == null) {
            this.search = new FindDialog(this, title, this, "");
        }
        this.search.showDialog();
    }

    public void addText(String text) {
        this.data.addText(new WrappedContainer(text));
    }

    public void addTextTable(String single, String[] text, double percentage) {
        this.data.addText(new WrappedNames(single, text, percentage));
    }

    public void propertyChanged(String a, String b) {
        this.data.dirty();
    }

    public void clear() {
        this.data.reset();
    }

    public ListIterator find(String text) {
        return this.data.find(text);
    }

    public void scroll(int scrollSize) {
        this.data.setValue(this.data.getValue() + scrollSize);
        this.repaint();
    }

    public void scrollTo(int specifics) {
        this.data.setValue(specifics);
        this.repaint();
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int scrollSize = e.getScrollAmount() - 1;
        if (scrollSize <= 0) {
            scrollSize = 1;
        }
        if (e.getWheelRotation() >= 0) {
            this.data.setValue(this.data.getValue() + scrollSize);
            this.repaint();
        } else {
            this.data.setValue(this.data.getValue() - scrollSize);
            this.repaint();
        }
    }

    public WrappedDisplay() {
        this.scroller = new JScrollBar(1, 0, 0, 0, 0);
        this.display = new WrappedDisplayComponent();
        this.data = new WrappedData();
        this.display.setWrappedData(this.data);
        this.scroller.setModel(this.data);
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.data.addChangeListener(this.display);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroller, "East");
        this.add((Component)this.display, "Center");
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        ClientState.getClientState().addClientStateListener("ui.font", this);
    }

    public void mousePressed(MouseEvent ev) {
        if (ev.isPopupTrigger()) {
            this.data.setValueIsAdjusting(false);
            return;
        }
        this.data.setValueIsAdjusting(true);
        this.data.setSelection(new SelectionSpace(ev.getPoint()));
        this.repaint();
    }

    public void mouseReleased(MouseEvent ev) {
        this.data.setValueIsAdjusting(false);
        if (ev.isPopupTrigger()) {
            return;
        }
        if (this.data.getSelection() != null && this.data.getSelection().getSelectedText() != null && this.data.getSelection().getSelectedText().length() > 0) {
            StringSelection selected = new StringSelection(this.data.getSelection().getSelectedText());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selected, selected);
            if (Toolkit.getDefaultToolkit().getSystemSelection() != null) {
                Toolkit.getDefaultToolkit().getSystemSelection().setContents(selected, selected);
            }
        }
        this.data.setSelection(null);
        this.repaint();
    }

    public void mouseClicked(MouseEvent ev) {
        if (ev.isPopupTrigger()) {
            this.data.setValueIsAdjusting(false);
            return;
        }
        if (ev.isShiftDown()) {
            WrappedObject temp = this.data.getAttributesAt(this.display.getHeight(), ev.getX(), ev.getY());
            if (temp != null && temp.getObject() != null) {
                AttributedText attribs = (AttributedText)temp.getObject();
                int index = ev.isControlDown() && attribs.backIndex > -1 ? attribs.backIndex : attribs.foreIndex;
                ModifyColorMapDialog.showModifyColorMapDialog(this, index);
            }
            return;
        }
        WrappedObject temp = this.data.getTokenAt(this.display.getHeight(), ev.getX(), ev.getY());
        if (temp != null && temp.getObject() != null) {
            if (this.fireClickEvent(temp.getObject().toString(), temp.getText(), ev).isAcknowledged()) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(300L);
                            WrappedDisplay.this.setCursor(Cursor.getDefaultCursor());
                        }
                        catch (Exception zex) {
                            zex.printStackTrace();
                        }
                    }
                }).start();
            }
        } else {
            String wname = SessionManager.getGlobalCapabilities().getActiveSession().getActiveWindow().getName();
            this.fireClickEvent(null, wname, ev);
        }
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseDragged(MouseEvent ev) {
        if (ev.isPopupTrigger()) {
            return;
        }
        if (this.data.getSelection() != null) {
            this.data.getSelection().growSelection(ev.getPoint());
            Rectangle temp = this.data.getSelection().getChangedArea();
            this.repaint(temp);
        }
    }

    public void mouseMoved(MouseEvent ev) {
    }

    public void addClickListener(ClickListener l) {
        this.listeners.add(l);
    }

    public ClickEvent fireClickEvent(String text, String context, MouseEvent ev) {
        ClickEvent event = new ClickEvent(text, context, ev);
        ListIterator i = this.listeners.listIterator();
        while (i.hasNext() && !event.isConsumed()) {
            ClickListener l = (ClickListener)i.next();
            if (text == null && !(l instanceof WindowAreaClickListener)) continue;
            l.wordClicked(event);
        }
        return event;
    }
}

