/*
 * Decompiled with CFR 0.152.
 */
package text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.GlobalCapabilities;
import rero.gui.SessionManager;
import text.AttributedText;

public class TextSource {
    public static Font clientFont;
    public static FontMetrics fontMetrics;
    private static Object antiAliasHint;
    public static final int UNIVERSAL_TWEAK = 2;
    protected static TextSourceListener listener;
    public static Color[] colorTable;

    public static void saveColorMap() {
        try {
            FileOutputStream ostream = new FileOutputStream(new File(ClientState.getBaseDirectory(), "color.map"));
            ObjectOutputStream o = new ObjectOutputStream(ostream);
            o.writeObject(colorTable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ClientState.getClientState().fireChange("color.map", null);
    }

    public static void initGraphics(Graphics g) {
        g.setFont(clientFont);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antiAliasHint);
    }

    public static int translateToLineNumber(int pixely) {
        return (pixely - 5) / (fontMetrics.getHeight() + 2);
    }

    public static void drawForeground(Graphics g, AttributedText text, int x_component, int baseline) {
        int height = fontMetrics.getHeight();
        while (text != null) {
            g.setColor(colorTable[text.foreIndex]);
            if (text.isBold) {
                g.setColor(g.getColor().brighter());
            }
            if (text.isReverse) {
                g.setColor(g.getColor().darker());
            }
            if (text.isUnderline) {
                g.drawLine(x_component, baseline + 1, x_component + text.width, baseline + 1);
            }
            g.drawString(text.text, x_component, baseline);
            x_component += text.width;
            text = text.next;
        }
    }

    public static void drawBackground(Graphics g, AttributedText text, int x_component, int baseline) {
        int height = fontMetrics.getHeight();
        while (text != null) {
            if (text.backIndex != -1) {
                g.setColor(colorTable[text.backIndex]);
                g.fillRect(x_component, baseline - height + 2, text.width, height + 2);
            }
            x_component += text.width;
            text = text.next;
        }
    }

    public static void drawText(Graphics g, AttributedText text, int x_component, int baseline) {
        TextSource.drawBackground(g, text, x_component, baseline);
        TextSource.drawForeground(g, text, x_component, baseline);
    }

    static {
        try {
            ObjectInputStream p = new ObjectInputStream(ClientState.getClientState().getResourceAsStream("color.map"));
            colorTable = (Color[])p.readObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (colorTable == null) {
            colorTable = new Color[100];
            TextSource.colorTable[0] = Color.lightGray;
            TextSource.colorTable[1] = new Color(0, 0, 0);
            TextSource.colorTable[2] = new Color(0, 0, 128);
            TextSource.colorTable[3] = new Color(0, 144, 0);
            TextSource.colorTable[4] = new Color(255, 0, 0);
            TextSource.colorTable[5] = new Color(128, 0, 0);
            TextSource.colorTable[6] = new Color(160, 0, 160);
            TextSource.colorTable[7] = new Color(255, 128, 0);
            TextSource.colorTable[8] = new Color(255, 255, 0);
            TextSource.colorTable[9] = new Color(0, 255, 0);
            TextSource.colorTable[10] = new Color(0, 144, 144);
            TextSource.colorTable[11] = new Color(0, 255, 255);
            TextSource.colorTable[12] = new Color(0, 0, 255);
            TextSource.colorTable[13] = new Color(255, 0, 255);
            TextSource.colorTable[14] = new Color(128, 128, 128);
            TextSource.colorTable[15] = Color.lightGray;
            TextSource.colorTable[16] = new Color(255, 255, 255);
            for (int x = 17; x < colorTable.length; ++x) {
                TextSource.colorTable[x] = colorTable[0];
            }
            TextSource.saveColorMap();
        }
        listener = new TextSourceListener();
    }

    private static class AdjustedFontMetrics
    extends FontMetrics {
        private int adj_ascent;
        private int adj_descent;
        private int height;
        private FontMetrics metrics;
        private FontRenderContext context;
        private Font font;

        public AdjustedFontMetrics(Font wayneFonts, FontMetrics _metrics) {
            super(wayneFonts);
            this.metrics = _metrics;
            this.adj_ascent = Math.abs(this.metrics.getMaxAscent());
            this.adj_descent = Math.abs(this.metrics.getMaxDescent());
            this.context = new FontRenderContext(null, antiAliasHint == RenderingHints.VALUE_TEXT_ANTIALIAS_ON, false);
            this.font = wayneFonts;
            this.height = this.adj_ascent + this.adj_descent;
        }

        public int getAscent() {
            return this.adj_ascent;
        }

        public int getDescent() {
            return this.adj_descent;
        }

        public int getHeight() {
            return this.height;
        }

        public int stringWidth(String str) {
            return (int)Math.round(this.font.getStringBounds(str, this.context).getWidth());
        }
    }

    protected static class TextSourceListener
    implements ClientStateListener {
        public TextSourceListener() {
            ClientState.getClientState().addClientStateListener("ui.font", this);
            ClientState.getClientState().addClientStateListener("ui.antialias", this);
            this.rehashValue();
        }

        public void rehashValue() {
            if (ClientState.getClientState().isOption("ui.antialias", ClientDefaults.ui_antialias)) {
                antiAliasHint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            } else {
                antiAliasHint = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
            }
            clientFont = ClientState.getClientState().getFont("ui.font", ClientDefaults.ui_font);
            fontMetrics = new AdjustedFontMetrics(clientFont, Toolkit.getDefaultToolkit().getFontMetrics(clientFont));
        }

        public void propertyChanged(String value, String parms) {
            this.rehashValue();
            SessionManager.getGlobalCapabilities();
            GlobalCapabilities.frame.validate();
            SessionManager.getGlobalCapabilities();
            GlobalCapabilities.frame.repaint();
        }
    }
}

