/*
 * Decompiled with CFR 0.152.
 */
package text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.MouseInputListener;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import text.AttributedText;
import text.ModifyColorMapDialog;
import text.list.ListData;
import text.list.ListDisplayComponent;
import text.list.ListElement;
import text.list.ListSelectionSpace;

public class ListDisplay
extends JComponent
implements MouseWheelListener,
MouseInputListener,
ClientStateListener {
    protected ListDisplayComponent display;
    protected JScrollBar scroller = new JScrollBar(1, 0, 0, 0, 0);
    protected ListData data;
    protected ListSelectionSpace select;

    public ListElement getSelectedElement() {
        return this.select.getSelectedElement();
    }

    public LinkedList getSelectedElements() {
        return this.select.getSelectedElements();
    }

    public void propertyChanged(String a, String b) {
        this.data.dirty();
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() >= 0) {
            this.scroller.setValue(this.scroller.getValue() + e.getScrollAmount());
            this.repaint();
        } else {
            this.scroller.setValue(this.scroller.getValue() - e.getScrollAmount());
            this.repaint();
        }
    }

    public ListDisplay(ListData data) {
        this.display = new ListDisplayComponent();
        this.select = new ListSelectionSpace(this, data);
        this.addMouseListener(this.select);
        this.addMouseMotionListener(this.select);
        this.data = data;
        this.display.installDataSource(data);
        this.scroller.setModel(data);
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        data.addChangeListener(this.display);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroller, "East");
        this.add((Component)this.display, "Center");
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        ClientState.getClientState().addClientStateListener("ui.font", this);
    }

    public void mousePressed(MouseEvent ev) {
    }

    public void mouseReleased(MouseEvent ev) {
    }

    public void mouseClicked(MouseEvent ev) {
        AttributedText attribs;
        ListElement temp;
        if (ev.isShiftDown() && ev.isControlDown() && (temp = this.data.getElementAtLocation(ev.getY())) != null && (attribs = temp.getAttributedText().getAttributesAt(ev.getX())) != null) {
            ModifyColorMapDialog.showModifyColorMapDialog(this, attribs.foreIndex);
            this.repaint();
            ev.consume();
        }
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseDragged(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }
}

