/*
 * Decompiled with CFR 0.152.
 */
package text;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import text.AttributedString;
import text.AttributedText;
import text.ModifyColorMapDialog;
import text.TextSource;

public class LabelDisplay
extends JComponent
implements MouseListener {
    protected int lines;
    protected AttributedString[] left;
    protected AttributedString[] right;
    protected int[] right_widths;

    public void setNumberOfLines(int l) {
        this.lines = l;
        this.left = new AttributedString[l];
        this.right = new AttributedString[l];
        this.right_widths = new int[l];
        this.revalidate();
    }

    public int getTotalLines() {
        return this.lines;
    }

    public Dimension getPreferredSize() {
        int potheight = this.lines * TextSource.fontMetrics.getHeight() + 2;
        return new Dimension(Integer.MAX_VALUE, potheight);
    }

    public void setLine(String left_text, String right_text, int lineno) {
        lineno = this.left.length - (lineno + 1);
        this.left[lineno] = AttributedString.CreateAttributedString(left_text);
        this.right[lineno] = AttributedString.CreateAttributedString(right_text);
        this.left[lineno].assignWidths();
        this.right[lineno].assignWidths();
        this.right_widths[lineno] = this.right[lineno].getAttributedText().getWidth();
    }

    public LabelDisplay() {
        this.setNumberOfLines(1);
        this.addMouseListener(this);
    }

    public void paint(Graphics g) {
        int x;
        TextSource.initGraphics(g);
        int checkY = g.getClipBounds().y - 9;
        int checkH = checkY + g.getClipBounds().height + 20;
        int width = super.getWidth();
        int height = super.getHeight();
        int baseline = height - TextSource.fontMetrics.getDescent() - 1;
        for (x = 0; x < this.left.length && baseline > 0 && this.left[x] != null; baseline -= TextSource.fontMetrics.getHeight(), ++x) {
            if (baseline > checkH || baseline < checkY) continue;
            TextSource.drawText(g, this.left[x].getAttributedText(), 0, baseline);
        }
        baseline = height - TextSource.fontMetrics.getDescent() - 1;
        for (x = 0; x < this.right.length && baseline > 0 && this.right[x] != null; baseline -= TextSource.fontMetrics.getHeight(), ++x) {
            if (baseline > checkH || baseline < checkY) continue;
            TextSource.drawText(g, this.right[x].getAttributedText(), width - this.right_widths[x], baseline);
        }
    }

    public int translateToLineNumber(int pixely) {
        int baseline = this.getHeight() - TextSource.fontMetrics.getDescent() - 1;
        for (int x = 0; x < this.left.length && baseline > 0 && this.left[x] != null; baseline -= TextSource.fontMetrics.getHeight() + 0, ++x) {
            if (pixely < baseline - TextSource.fontMetrics.getHeight() - 0) continue;
            return x;
        }
        return 0;
    }

    public void mousePressed(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseReleased(MouseEvent ev) {
    }

    public void mouseClicked(MouseEvent ev) {
        if (ev.isShiftDown()) {
            AttributedText iter;
            int width;
            int lineno = this.translateToLineNumber(ev.getY());
            if (ev.getX() >= this.getWidth() - this.right_widths[lineno]) {
                width = this.getWidth() - this.right_widths[lineno];
                iter = this.right[lineno].getAttributedText();
            } else {
                width = 0;
                iter = this.left[lineno].getAttributedText();
            }
            while (iter != null && iter.width + width < ev.getX()) {
                width += iter.width;
                iter = iter.next;
            }
            if (iter != null) {
                int index = ev.isControlDown() && iter.backIndex > -1 ? iter.backIndex : iter.foreIndex;
                ModifyColorMapDialog.showModifyColorMapDialog(this, index);
            }
            return;
        }
    }
}

