/*
 * Decompiled with CFR 0.152.
 */
package text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rero.gui.KeyBindings;
import text.WrappedDisplay;

public class FindDialog
extends JDialog
implements ActionListener,
KeyListener {
    protected JButton next;
    protected JButton prev;
    protected WrappedDisplay display;
    protected JTextField search;
    protected ListIterator results = null;
    protected Object lastSource = null;

    public void showDialog() {
        KeyBindings.is_dialog_active = true;
        this.results = null;
        this.next.setEnabled(false);
        this.prev.setEnabled(true);
        this.pack();
        this.setLocationRelativeTo(this.display);
        this.setVisible(true);
        this.search.selectAll();
        this.search.requestFocus();
    }

    public FindDialog(Component comp, String title, WrappedDisplay _display, String text) {
        super(JOptionPane.getFrameForComponent(comp), title, false);
        this.display = _display;
        this.getContentPane().setLayout(new BorderLayout());
        this.search = new JTextField(text, 20);
        this.search.addKeyListener(this);
        this.search.addActionListener(this);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(new FlowLayout());
        panel.add(new JLabel("Find: "));
        panel.add(this.search);
        this.getContentPane().add((Component)panel, "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2));
        this.next = new JButton("Next");
        this.next.setMnemonic('N');
        this.next.setEnabled(false);
        this.next.addActionListener(this);
        this.prev = new JButton("Previous");
        this.prev.setMnemonic('P');
        this.prev.setEnabled(text.length() > 0);
        this.prev.addActionListener(this);
        buttons.add(this.prev);
        buttons.add(this.next);
        this.getContentPane().add((Component)buttons, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                KeyBindings.is_dialog_active = false;
                FindDialog.this.setVisible(false);
            }
        });
    }

    public static void main(String[] args) {
        FindDialog temp = new FindDialog(null, "Testing", null, "hi");
        temp.showDialog();
    }

    public void keyTyped(KeyEvent ev) {
    }

    public void keyPressed(KeyEvent ev) {
    }

    public void keyReleased(KeyEvent ev) {
        if (ev.getKeyCode() == 27) {
            KeyBindings.is_dialog_active = false;
            this.setVisible(false);
            ev.consume();
        } else if (!ev.isActionKey() && ev.getKeyCode() != 10) {
            this.results = null;
            this.next.setEnabled(this.search.getText().length() > 0);
            this.prev.setEnabled(this.search.getText().length() > 0);
        }
    }

    public void actionPerformed(ActionEvent ev) {
        if (this.results == null) {
            this.results = this.display.find(this.search.getText());
            this.lastSource = null;
        }
        if (ev.getSource() == this.next && this.results.hasNext()) {
            if (this.lastSource == this.prev) {
                this.results.next();
            }
            int gotoz = (Integer)this.results.next();
            this.display.scrollTo(gotoz);
            this.lastSource = this.next;
        } else if ((ev.getSource() == this.prev || ev.getSource() == this.search) && this.results.hasPrevious()) {
            if (this.lastSource == this.next) {
                this.results.previous();
            }
            int gotoz = (Integer)this.results.previous();
            this.display.scrollTo(gotoz);
            this.lastSource = this.prev;
        }
        this.next.setEnabled(this.results.hasNext());
        this.prev.setEnabled(this.results.hasPrevious());
        this.search.requestFocus();
    }
}

