/*
 * Decompiled with CFR 0.152.
 */
package text;

import text.TextSource;

public class AttributedText {
    public static int INSTANCES = 0;
    public int foreIndex = 0;
    public int backIndex = -1;
    public boolean isUnderline = false;
    public boolean isBold = false;
    public boolean isReverse = false;
    public int start = 0;
    public int end = 0;
    public int width;
    public AttributedText next;
    public String text;

    public AttributedText() {
        ++INSTANCES;
    }

    public void finalize() {
        --INSTANCES;
    }

    public AttributedText copyAttributes() {
        AttributedText temp = new AttributedText();
        temp.foreIndex = this.foreIndex;
        temp.backIndex = this.backIndex;
        temp.isUnderline = this.isUnderline;
        temp.isBold = this.isBold;
        temp.isReverse = this.isReverse;
        return temp;
    }

    public AttributedText cloneAttributedText() {
        AttributedText temp = this.copyAttributes();
        temp.width = this.width;
        temp.text = this.text;
        return temp;
    }

    public AttributedText cloneList() {
        AttributedText head;
        AttributedText tail = head = this.cloneAttributedText();
        AttributedText temp = this.next;
        while (temp != null) {
            tail = tail.next = temp.cloneAttributedText();
            temp = temp.next;
        }
        return head;
    }

    public void setIndent() {
        this.start = Integer.MAX_VALUE;
        this.end = Integer.MIN_VALUE;
    }

    public boolean isIndent() {
        return this.start == Integer.MAX_VALUE && this.end == Integer.MIN_VALUE;
    }

    public int getWidth() {
        int width = 0;
        AttributedText temp = this;
        while (temp != null) {
            width += temp.width;
            temp = temp.next;
        }
        return width;
    }

    public AttributedText getAttributesAt(int location) {
        if (location < this.width) {
            return this;
        }
        if (this.next != null) {
            return this.next.getAttributesAt(location - this.width);
        }
        return null;
    }

    public String getText() {
        StringBuffer rv = new StringBuffer();
        AttributedText temp = this;
        while (temp != null) {
            rv.append(temp.text);
            temp = temp.next;
        }
        return rv.toString();
    }

    private static int findIndex(String text, int max_size, int start, int width) {
        int x = start + 1;
        int twidth = 0;
        while (x + x < text.length() && twidth < max_size) {
            x += x;
            twidth = TextSource.fontMetrics.stringWidth(text.substring(0, x)) + width;
        }
        x /= 2;
        twidth = 0;
        while (x < text.length() && twidth < max_size) {
            twidth = TextSource.fontMetrics.stringWidth(text.substring(0, x)) + width;
            ++x;
        }
        return x - 1;
    }

    public String getRange(int x_start, int x_end) {
        AttributedText temp = this;
        StringBuffer rv = new StringBuffer();
        int width = 0;
        while (temp != null) {
            int x;
            int start = width;
            int end = width + temp.width;
            if (x_start > start && x_end <= end) {
                x = AttributedText.findIndex(temp.text, x_start, 0, width);
                int y = AttributedText.findIndex(temp.text, x_end, x, width);
                return temp.text.substring(x, y);
            }
            if (x_start <= start && x_end >= end) {
                rv.append(temp.text);
            } else if (x_start <= start && x_end <= end && x_end > x_start) {
                x = AttributedText.findIndex(temp.text, x_end, 0, width);
                if (x > 1) {
                    rv.append(temp.text.substring(0, x));
                }
            } else if (x_start > start && x_start <= end && x_end >= end) {
                x = AttributedText.findIndex(temp.text, x_end, 0, width);
                rv.append(temp.text.substring(x, temp.text.length()));
            }
            width += temp.width;
            temp = temp.next;
        }
        return rv.toString();
    }

    public String toString() {
        String attribs = "";
        if (this.isBold) {
            attribs = attribs + "B";
        }
        if (this.isUnderline) {
            attribs = attribs + "U";
        }
        if (this.isReverse) {
            attribs = attribs + "R";
        }
        String addon = "|";
        if (this.next != null) {
            addon = this.next.toString();
        }
        if (this.start == 0 && this.end == 0) {
            return "[\"" + this.text + "\"," + this.width + "px:" + attribs + ":" + this.foreIndex + "," + this.backIndex + "]->" + addon;
        }
        return "[\"" + this.text + "\"," + this.start + "-" + this.end + ":" + attribs + ":" + this.foreIndex + "," + this.backIndex + "]->" + addon;
    }
}

