/*
 * Decompiled with CFR 0.152.
 */
package text;

import rero.util.TokenizedString;
import text.AttributedText;
import text.TextSource;

public class AttributedString {
    public static final char bold = '\u0002';
    public static final char underline = '\u001f';
    public static final char color = '\u0003';
    public static final char cancel = '\u000f';
    public static final char reverse = '\u0016';
    public static final char tab = '\t';
    protected AttributedText attrs;
    protected TokenizedString tokens;
    protected String text;

    public AttributedString(String _text, AttributedText _attrs) {
        this(_text, _attrs, " ");
    }

    public AttributedString(String _text, AttributedText _attrs, String delimeter) {
        this.text = _text;
        this.attrs = _attrs;
        this.tokens = new TokenizedString(this.text, delimeter);
    }

    public String getText() {
        return this.text;
    }

    public TokenizedString getTokens() {
        return this.tokens;
    }

    public AttributedText getAttributedText() {
        return this.attrs;
    }

    public AttributedText substring(int start, int end) {
        return this.substring(this.attrs, start, end);
    }

    public void assignWidths() {
        AttributedText head = this.attrs;
        while (head != null) {
            head.width = TextSource.fontMetrics.stringWidth(head.text);
            head = head.next;
        }
    }

    public AttributedText substring(AttributedText original, int start, int end) {
        AttributedText temp = original;
        while (temp != null) {
            if (start > temp.start && end <= temp.end) {
                AttributedText head = temp.copyAttributes();
                head.text = this.text.substring(start, end);
                head.width = TextSource.fontMetrics.stringWidth(head.text);
                return head;
            }
            if (start <= temp.start && end >= temp.end) {
                AttributedText head = temp.copyAttributes();
                head.text = temp.text;
                head.width = TextSource.fontMetrics.stringWidth(head.text);
                head.next = this.substring(temp.next, start, end);
                return head;
            }
            if (start <= temp.start && end <= temp.end && end > temp.start) {
                AttributedText head = temp.copyAttributes();
                head.text = this.text.substring(temp.start, end);
                head.width = TextSource.fontMetrics.stringWidth(head.text);
                return head;
            }
            if (start > temp.start && start <= temp.end && end >= temp.end) {
                AttributedText head = temp.copyAttributes();
                head.text = this.text.substring(start, temp.end);
                head.width = TextSource.fontMetrics.stringWidth(head.text);
                head.next = this.substring(temp.next, start, end);
                return head;
            }
            temp = temp.next;
        }
        return null;
    }

    public static AttributedString CreateAttributedString(String text) {
        return AttributedString.CreateAttributedString(text, " ");
    }

    public static AttributedString CreateAttributedString(String text, String delim) {
        AttributedText current = new AttributedText();
        StringBuffer result = new StringBuffer();
        StringBuffer stripped = new StringBuffer();
        AttributedText head = current;
        char[] data = text.toCharArray();
        block8: for (int x = 0; x < data.length; ++x) {
            switch (data[x]) {
                case '\u0002': {
                    if (result.length() > 0) {
                        current.text = result.toString();
                        current.end = current.start + current.text.length();
                        result = new StringBuffer();
                        current.next = current.copyAttributes();
                        current.next.start = current.end;
                        current = current.next;
                    }
                    current.isBold = !current.isBold;
                    continue block8;
                }
                case '\u0003': {
                    int back = current.backIndex;
                    int fore = current.foreIndex;
                    if (x + 1 < data.length && Character.isDigit(data[x + 1])) {
                        if (x + 2 < data.length && Character.isDigit(data[x + 2])) {
                            fore = Character.digit(data[x + 1], 10) * 10 + Character.digit(data[x + 2], 10);
                            x += 2;
                        } else {
                            fore = Character.digit(data[x + 1], 10);
                            ++x;
                        }
                        if (x + 2 < data.length && data[x + 1] == ',' && Character.isDigit(data[x + 2])) {
                            if (++x + 2 < data.length && Character.isDigit(data[x + 2])) {
                                back = Character.digit(data[x + 1], 10) * 10 + Character.digit(data[x + 2], 10);
                                x += 2;
                            } else {
                                back = Character.digit(data[x + 1], 10);
                                ++x;
                            }
                        }
                    }
                    if (fore == current.foreIndex && back == current.backIndex) continue block8;
                    if (result.length() > 0) {
                        current.text = result.toString();
                        current.end = current.start + current.text.length();
                        result = new StringBuffer();
                        current.next = current.copyAttributes();
                        current.next.start = current.end;
                        current = current.next;
                    }
                    current.foreIndex = fore;
                    current.backIndex = back;
                    continue block8;
                }
                case '\u000f': {
                    if (result.length() > 0) {
                        current.text = result.toString();
                        current.end = current.start + current.text.length();
                        result = new StringBuffer();
                        current.next = new AttributedText().copyAttributes();
                        current.next.foreIndex = current.foreIndex;
                        current.next.start = current.end;
                        current = current.next;
                        continue block8;
                    }
                    current.isBold = false;
                    current.isUnderline = false;
                    current.isReverse = false;
                    current.backIndex = -1;
                    current.foreIndex = 0;
                    continue block8;
                }
                case '\u0016': {
                    if (result.length() > 0) {
                        current.text = result.toString();
                        current.end = current.start + current.text.length();
                        result = new StringBuffer();
                        current.next = current.copyAttributes();
                        current.next.start = current.end;
                        current = current.next;
                    }
                    current.isReverse = !current.isReverse;
                    continue block8;
                }
                case '\u001f': {
                    if (result.length() > 0) {
                        current.text = result.toString();
                        current.end = current.start + current.text.length();
                        result = new StringBuffer();
                        current.next = current.copyAttributes();
                        current.next.start = current.end;
                        current = current.next;
                    }
                    current.isUnderline = !current.isUnderline;
                    continue block8;
                }
                case '\t': {
                    result.append("   ");
                    stripped.append("   ");
                    continue block8;
                }
                default: {
                    result.append(data[x]);
                    stripped.append(data[x]);
                }
            }
        }
        current.text = result.toString();
        current.end = current.start + current.text.length();
        return new AttributedString(stripped.toString(), head, delim);
    }
}

