/*
 * Decompiled with CFR 0.152.
 */
package text;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import text.AttributedString;
import text.AttributedText;
import text.ModifyColorMapDialog;
import text.TextSource;

public class AttributedLabel
extends JComponent
implements MouseListener {
    protected AttributedString left;

    public Dimension getPreferredSize() {
        return new Dimension(this.left.getAttributedText().getWidth(), TextSource.fontMetrics.getHeight() + 2);
    }

    public void setText(AttributedString string) {
        this.left = string;
    }

    public void setText(String text) {
        this.left = AttributedString.CreateAttributedString(text);
        this.left.assignWidths();
    }

    public AttributedLabel() {
        this.setText("");
        this.addMouseListener(this);
    }

    public AttributedLabel(String text) {
        this.setText(text);
        this.addMouseListener(this);
    }

    public void paint(Graphics g) {
        TextSource.initGraphics(g);
        int width = super.getWidth();
        int height = super.getHeight();
        int baseline = height - 4;
        TextSource.drawText(g, this.left.getAttributedText(), 2, baseline);
    }

    public void mousePressed(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseReleased(MouseEvent ev) {
    }

    public void mouseClicked(MouseEvent ev) {
        if (ev.isShiftDown()) {
            int width = 2;
            AttributedText iter = this.left.getAttributedText();
            while (iter != null && iter.width + width < ev.getX()) {
                width += iter.width;
                iter = iter.next;
            }
            if (iter != null) {
                int index = ev.isControlDown() && iter.backIndex > -1 ? iter.backIndex : iter.foreIndex;
                ModifyColorMapDialog.showModifyColorMapDialog(this, index);
            }
            ev.consume();
            return;
        }
    }
}

