/*
 * Decompiled with CFR 0.152.
 */
package sleep.taint;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import sleep.bridges.KeyValuePair;
import sleep.engine.types.ObjectValue;
import sleep.runtime.CollectionWrapper;
import sleep.runtime.MapWrapper;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;
import sleep.taint.Sanitizer;
import sleep.taint.Sensitive;
import sleep.taint.TaintArray;
import sleep.taint.TaintHash;
import sleep.taint.TaintedValue;
import sleep.taint.Tainter;

public class TaintUtils {
    private static boolean isTaintMode = System.getProperty("sleep.taint", "false").equals("true");

    public static boolean isTaintMode() {
        return isTaintMode;
    }

    public static Scalar taint(Scalar value) {
        if (TaintUtils.isTaintMode() && value.getActualValue() != null) {
            value.setValue(new TaintedValue(value.getActualValue()));
        }
        return value;
    }

    public static Stack taint(Stack values) {
        if (TaintUtils.isTaintMode()) {
            Iterator i = values.iterator();
            while (i.hasNext()) {
                TaintUtils.taintAll((Scalar)i.next());
            }
        }
        return values;
    }

    public static Scalar taintAll(Scalar value) {
        if (value.getArray() != null && value.getArray().getClass() == CollectionWrapper.class) {
            value.setValue(new TaintArray(value.getArray()));
        } else if (value.getArray() != null) {
            Iterator i = value.getArray().scalarIterator();
            while (i.hasNext()) {
                TaintUtils.taintAll((Scalar)i.next());
            }
        } else if (value.getHash() != null && value.getHash().getClass() == MapWrapper.class) {
            value.setValue(new TaintHash(value.getHash()));
        } else if (value.getHash() != null) {
            Iterator i = value.getHash().getData().entrySet().iterator();
            while (i.hasNext()) {
                TaintUtils.taintAll((Scalar)((Object)i.next()));
            }
        } else if (value.getActualValue().getType() == ObjectValue.class && value.objectValue().getClass() == KeyValuePair.class) {
            KeyValuePair kvp = (KeyValuePair)value.objectValue();
            value.setValue(SleepUtils.getScalar(new KeyValuePair(kvp.getKey(), TaintUtils.taintAll(kvp.getValue()))));
        } else if (value.getActualValue() != null) {
            value.setValue(new TaintedValue(value.getActualValue()));
        }
        return value;
    }

    public static Scalar untaint(Scalar value) {
        if (value.getActualValue() != null && value.getActualValue().getClass() == TaintedValue.class) {
            value.setValue(((TaintedValue)value.getActualValue()).untaint());
        }
        return value;
    }

    private static boolean isTainted(Set seen, Scalar value) {
        if (value.getHash() != null) {
            if (!seen.contains(value.getHash())) {
                seen.add(value.getHash());
                Iterator i = value.getHash().getData().values().iterator();
                while (i.hasNext()) {
                    if (!TaintUtils.isTainted(seen, (Scalar)i.next())) continue;
                    return true;
                }
            }
            return false;
        }
        if (value.getArray() != null) {
            if (!seen.contains(value.getArray())) {
                seen.add(value.getArray());
                Iterator i = value.getArray().scalarIterator();
                while (i.hasNext()) {
                    if (!TaintUtils.isTainted(seen, (Scalar)i.next())) continue;
                    return true;
                }
            }
            return false;
        }
        return value.getActualValue().getClass() == TaintedValue.class && !SleepUtils.isEmptyScalar(value);
    }

    public static boolean isTainted(Scalar value) {
        if (value.getActualValue() == null) {
            return TaintUtils.isTainted(new HashSet(), value);
        }
        return TaintUtils.isTainted(null, value);
    }

    public static Object Sanitizer(Object f) {
        if (TaintUtils.isTaintMode()) {
            return new Sanitizer(f);
        }
        return f;
    }

    public static Object Tainter(Object f) {
        if (TaintUtils.isTaintMode()) {
            return new Tainter(f);
        }
        return f;
    }

    public static Object Sensitive(Object f) {
        if (TaintUtils.isTaintMode()) {
            return new Sensitive(f);
        }
        return f;
    }

    public static String checkArguments(Stack arguments) {
        Stack<Scalar> values = new Stack<Scalar>();
        String desc = null;
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            Scalar argument = (Scalar)i.next();
            if (!TaintUtils.isTainted(argument)) continue;
            values.push(argument);
        }
        if (!values.isEmpty()) {
            desc = SleepUtils.describe(values);
        }
        return desc;
    }
}

