/*
 * Decompiled with CFR 0.152.
 */
package sleep.taint;

import sleep.engine.Step;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;
import sleep.taint.PermeableStep;
import sleep.taint.TaintUtils;

public class TaintObjectAccess
extends PermeableStep {
    protected String name;
    protected Class classRef;

    public TaintObjectAccess(Step wrapit, String _name, Class _classRef) {
        super(wrapit);
        this.name = _name;
        this.classRef = _classRef;
    }

    public Scalar evaluate(ScriptEnvironment e) {
        Scalar scalar = null;
        Object value = null;
        if (this.classRef != null || SleepUtils.isFunctionScalar((Scalar)e.getCurrentFrame().peek())) {
            return super.evaluate(e);
        }
        String desc = e.hasFrame() ? TaintUtils.checkArguments(e.getCurrentFrame()) : null;
        scalar = (Scalar)e.getCurrentFrame().peek();
        if (desc != null && !TaintUtils.isTainted(scalar)) {
            TaintUtils.taint(scalar);
            if ((e.getScriptInstance().getDebugFlags() & 0x80) == 128) {
                e.getScriptInstance().fireWarning("tainted object: " + SleepUtils.describe(scalar) + " from: " + desc, this.getLineNumber());
            }
        }
        return this.callit(e, desc);
    }
}

