/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScalarType;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;
import sleep.taint.TaintedValue;

public class WatchScalar
extends Scalar {
    protected ScriptEnvironment owner;
    protected String name;

    public WatchScalar(String _name, ScriptEnvironment _owner) {
        this.name = _name;
        this.owner = _owner;
    }

    public void flagChange(Scalar valuez) {
        if (this.owner != null && (this.value != null || this.array != null || this.hash != null)) {
            this.owner.showDebugMessage("watch(): " + this.name + " = " + SleepUtils.describe(valuez));
        }
    }

    public void setValue(ScalarType _value) {
        if (_value.getClass() != TaintedValue.class || ((TaintedValue)_value).untaint() != this.value) {
            Scalar blah = new Scalar();
            blah.setValue(_value);
            this.flagChange(blah);
        }
        super.setValue(_value);
    }

    public void setValue(ScalarArray _array) {
        Scalar blah = new Scalar();
        blah.setValue(_array);
        this.flagChange(blah);
        super.setValue(_array);
    }

    public void setValue(ScalarHash _hash) {
        Scalar blah = new Scalar();
        blah.setValue(_hash);
        this.flagChange(blah);
        super.setValue(_hash);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (SleepUtils.isEmptyScalar(this)) {
            out.writeObject(null);
        } else {
            out.writeObject(this.value);
        }
        out.writeObject(this.array);
        out.writeObject(this.hash);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = (ScalarType)in.readObject();
        this.array = (ScalarArray)in.readObject();
        this.hash = (ScalarHash)in.readObject();
        if (this.value == null && this.array == null && this.hash == null) {
            this.setValue(SleepUtils.getEmptyScalar());
        }
    }
}

