/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.KeyValuePair;
import sleep.bridges.SleepClosure;
import sleep.bridges.io.IOObject;
import sleep.engine.Block;
import sleep.engine.CallRequest;
import sleep.engine.ProxyInterface;
import sleep.engine.types.DoubleValue;
import sleep.engine.types.HashContainer;
import sleep.engine.types.IntValue;
import sleep.engine.types.ListContainer;
import sleep.engine.types.LongValue;
import sleep.engine.types.NullValue;
import sleep.engine.types.ObjectValue;
import sleep.engine.types.OrderedHashContainer;
import sleep.engine.types.StringValue;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Function;
import sleep.parser.Checkers;
import sleep.parser.Parser;
import sleep.runtime.CollectionWrapper;
import sleep.runtime.MapWrapper;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScalarType;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;

public class SleepUtils {
    public static final int SLEEP_RELEASE = 20080701;
    public static final String SLEEP_VERSION = "Sleep 2.1";
    protected static ScalarType nullScalar = new NullValue();

    public static void addKeyword(String keyword) {
        Checkers.addKeyword(keyword);
    }

    public static Block ParseCode(String code) throws YourCodeSucksException {
        Parser parser = new Parser("eval", code);
        parser.parse();
        return parser.getRunnableBlock();
    }

    public static void removeScalar(Iterator collection, Scalar value) {
        while (collection.hasNext()) {
            Scalar next = (Scalar)collection.next();
            if (!value.sameAs(next)) continue;
            collection.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Scalar runCode(CallRequest request, ScriptInstance script, Stack locals) {
        ScriptEnvironment environment = script.getScriptEnvironment();
        ScriptVariables scriptVariables = environment.getScriptVariables();
        synchronized (scriptVariables) {
            environment.pushSource(script.getName());
            environment.CreateFrame();
            environment.CreateFrame(locals);
            request.CallFunction();
            Scalar rv = environment.getCurrentFrame().isEmpty() ? SleepUtils.getEmptyScalar() : (Scalar)environment.getCurrentFrame().pop();
            environment.KillFrame();
            environment.popSource();
            environment.resetEnvironment();
            return rv;
        }
    }

    public static Scalar runCode(Block code, ScriptEnvironment env) {
        if (env.getScriptVariables().getLocalVariables() == null) {
            env.getScriptVariables().pushLocalLevel();
            CallRequest.InlineCallRequest request = new CallRequest.InlineCallRequest(env, Integer.MIN_VALUE, "eval", code);
            Scalar value = SleepUtils.runCode(request, env.getScriptInstance(), null);
            env.getScriptVariables().popLocalLevel();
            return value;
        }
        CallRequest.InlineCallRequest request = new CallRequest.InlineCallRequest(env, Integer.MIN_VALUE, "eval", code);
        return SleepUtils.runCode(request, env.getScriptInstance(), null);
    }

    public static Scalar runCode(SleepClosure closure, String message, ScriptInstance script, Stack locals) {
        if (script == null) {
            script = closure.getOwner();
        }
        CallRequest.ClosureCallRequest request = new CallRequest.ClosureCallRequest(script.getScriptEnvironment(), Integer.MIN_VALUE, SleepUtils.getScalar(closure), message);
        return SleepUtils.runCode(request, script, locals);
    }

    public static Scalar runCode(Function func, String name, ScriptInstance script, Stack locals) {
        CallRequest.FunctionCallRequest request = new CallRequest.FunctionCallRequest(script.getScriptEnvironment(), Integer.MIN_VALUE, name, func);
        return SleepUtils.runCode(request, script, locals);
    }

    public static Scalar runCode(ScriptInstance script, Block code, HashMap vars) {
        CallRequest.InlineCallRequest request = new CallRequest.InlineCallRequest(script.getScriptEnvironment(), Integer.MIN_VALUE, "eval", code);
        return SleepUtils.runCode(request, script, SleepUtils.getArgumentStack(vars));
    }

    public static Scalar runCode(ScriptInstance owner, Block code) {
        return SleepUtils.runCode(owner, code, null);
    }

    public static Scalar getArrayWrapper(Collection dataStructure) {
        Scalar temp = new Scalar();
        temp.setValue(new CollectionWrapper(dataStructure));
        return temp;
    }

    public static Scalar getHashWrapper(Map dataStructure) {
        Scalar temp = new Scalar();
        temp.setValue(new MapWrapper(dataStructure));
        return temp;
    }

    public static Scalar getHashScalar(ScalarHash value) {
        Scalar temp = new Scalar();
        temp.setValue(value);
        return temp;
    }

    public static Scalar getArrayScalar(ScalarArray value) {
        Scalar temp = new Scalar();
        temp.setValue(value);
        return temp;
    }

    public static Scalar getArrayScalar() {
        Scalar temp = new Scalar();
        temp.setValue(new ListContainer());
        return temp;
    }

    public static Map getMapFromHash(Scalar map2) {
        return SleepUtils.getMapFromHash(map2.getHash());
    }

    public static Map getMapFromHash(ScalarHash map2) {
        HashMap<String, Object> dict = new HashMap<String, Object>();
        if (map2 != null) {
            Iterator i = map2.keys().scalarIterator();
            while (i.hasNext()) {
                Scalar key = (Scalar)i.next();
                Scalar val = map2.getAt(key);
                if (val.getHash() != null) {
                    dict.put(key.toString(), SleepUtils.getMapFromHash(val.getHash()));
                    continue;
                }
                if (val.getArray() != null) {
                    dict.put(key.toString(), SleepUtils.getListFromArray(val.getArray()));
                    continue;
                }
                dict.put(key.toString(), val.objectValue());
            }
        }
        return dict;
    }

    public static Stack getArgumentStack(Map pairs) {
        Stack<Scalar> locals = new Stack<Scalar>();
        if (pairs != null) {
            Iterator i = pairs.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry value = i.next();
                locals.push(SleepUtils.getScalar(new KeyValuePair(SleepUtils.getScalar(value.getKey().toString()), (Scalar)value.getValue())));
            }
        }
        return locals;
    }

    public static List getListFromArray(Scalar array2) {
        return SleepUtils.getListFromArray(array2.getArray());
    }

    public static List getListFromArray(ScalarArray array2) {
        LinkedList<Object> list = new LinkedList<Object>();
        if (array2 != null) {
            Iterator i = array2.scalarIterator();
            while (i.hasNext()) {
                Scalar temp = (Scalar)i.next();
                if (temp.getHash() != null) {
                    list.add(SleepUtils.getMapFromHash(temp.getHash()));
                    continue;
                }
                if (temp.getArray() != null) {
                    list.add(SleepUtils.getListFromArray(temp.getArray()));
                    continue;
                }
                list.add(temp.objectValue());
            }
        }
        return list;
    }

    public static Scalar getEmptyScalar() {
        Scalar temp = new Scalar();
        temp.setValue(nullScalar);
        return temp;
    }

    public static boolean isEmptyScalar(Scalar value) {
        return value == null || value.getActualValue() == nullScalar;
    }

    public static boolean isFunctionScalar(Scalar value) {
        return value.objectValue() != null && value.objectValue() instanceof SleepClosure;
    }

    public static SleepClosure getFunctionFromScalar(Scalar value) {
        if (value.objectValue() != null && value.objectValue() instanceof SleepClosure) {
            return (SleepClosure)value.objectValue();
        }
        return null;
    }

    public static SleepClosure getFunctionFromScalar(Scalar value, ScriptInstance script) {
        if (value.objectValue() != null && value.objectValue() instanceof SleepClosure) {
            return (SleepClosure)value.objectValue();
        }
        return (SleepClosure)script.getScriptEnvironment().getFunction(value.toString());
    }

    public static Scalar getIOHandleScalar(InputStream in, OutputStream out) {
        return SleepUtils.getScalar(SleepUtils.getIOHandle(in, out));
    }

    public static IOObject getIOHandle(InputStream in, OutputStream out) {
        IOObject handle = new IOObject();
        handle.openRead(in);
        handle.openWrite(out);
        return handle;
    }

    public static Object newInstance(Class initializeMe, SleepClosure closure, ScriptInstance owner) {
        return ProxyInterface.BuildInterface(initializeMe, (Function)closure, owner != null ? owner : closure.getOwner());
    }

    public static Object newInstance(Class initializeMe, Block code, ScriptInstance owner) {
        return ProxyInterface.BuildInterface(initializeMe, (Function)new SleepClosure(owner, code), owner);
    }

    public static String describe(Stack arguments) {
        StringBuffer values = new StringBuffer();
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            Scalar tempz = (Scalar)i.next();
            values.insert(0, SleepUtils.describe(tempz));
            if (!i.hasNext()) continue;
            values.insert(0, ", ");
        }
        return values.toString();
    }

    private static String describeEntries(List seen, Scalar scalar) {
        if (scalar.getArray() != null) {
            if (seen.contains(scalar.getArray())) {
                return "@" + seen.indexOf(scalar.getArray());
            }
            seen.add(scalar.getArray());
            StringBuffer buffer = new StringBuffer("@(");
            Iterator i = scalar.getArray().scalarIterator();
            while (i.hasNext()) {
                Scalar next = (Scalar)i.next();
                buffer.append(SleepUtils.describeEntries(seen, next));
                if (!i.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(")");
            return buffer.toString();
        }
        if (scalar.getHash() != null) {
            if (seen.contains(scalar.getHash())) {
                return "%" + seen.indexOf(scalar.getHash());
            }
            seen.add(scalar.getHash());
            StringBuffer buffer = new StringBuffer("%(");
            Iterator i = scalar.getHash().getData().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry next = i.next();
                Scalar value = (Scalar)next.getValue();
                if (SleepUtils.isEmptyScalar((Scalar)next.getValue())) continue;
                if (buffer.length() > 2) {
                    buffer.append(", ");
                }
                buffer.append(next.getKey());
                buffer.append(" => ");
                buffer.append(SleepUtils.describeEntries(seen, value));
            }
            buffer.append(")");
            return buffer.toString();
        }
        if (scalar.getActualValue().getType() == NullValue.class) {
            return "$null";
        }
        if (scalar.getActualValue().getType() == StringValue.class) {
            return "'" + scalar.toString() + "'";
        }
        if (SleepUtils.isFunctionScalar(scalar)) {
            return scalar.toString();
        }
        if (scalar.objectValue() instanceof KeyValuePair) {
            KeyValuePair kvp = (KeyValuePair)scalar.objectValue();
            return kvp.getKey().toString() + " => " + SleepUtils.describe(kvp.getValue());
        }
        if (scalar.getActualValue().getType() == ObjectValue.class) {
            return scalar.toString();
        }
        if (scalar.getActualValue().getType() == LongValue.class) {
            return scalar.toString() + "L";
        }
        return scalar.toString();
    }

    public static String describe(Scalar scalar) {
        return SleepUtils.describeEntries(new LinkedList(), scalar);
    }

    public static Scalar getHashScalar() {
        Scalar temp = new Scalar();
        temp.setValue(new HashContainer());
        return temp;
    }

    public static Scalar getOrderedHashScalar() {
        Scalar temp = new Scalar();
        temp.setValue(new OrderedHashContainer(11, 0.75f, false));
        return temp;
    }

    public static Scalar getAccessOrderedHashScalar() {
        Scalar temp = new Scalar();
        temp.setValue(new OrderedHashContainer(11, 0.75f, true));
        return temp;
    }

    public static Scalar getScalar(int x) {
        Scalar temp = new Scalar();
        temp.setValue(new IntValue(x));
        return temp;
    }

    public static Scalar getScalar(short x) {
        Scalar temp = new Scalar();
        temp.setValue(new IntValue(x));
        return temp;
    }

    public static Scalar getScalar(float x) {
        Scalar temp = new Scalar();
        temp.setValue(new DoubleValue(x));
        return temp;
    }

    public static Scalar getScalar(double x) {
        Scalar temp = new Scalar();
        temp.setValue(new DoubleValue(x));
        return temp;
    }

    public static Scalar getScalar(Scalar x) {
        Scalar temp = new Scalar();
        temp.setValue(x);
        return temp;
    }

    public static Scalar getScalar(long x) {
        Scalar temp = new Scalar();
        temp.setValue(new LongValue(x));
        return temp;
    }

    public static Scalar getScalar(byte[] x) {
        return SleepUtils.getScalar(x, x.length);
    }

    public static Scalar getScalar(byte[] x, int length) {
        Scalar temp = new Scalar();
        StringBuffer buff = new StringBuffer(length);
        for (int y = 0; y < length; ++y) {
            char append = (char)(x[y] & 0xFF);
            buff.append(append);
        }
        temp.setValue(new StringValue(buff.toString()));
        return temp;
    }

    public static Scalar getScalar(String x) {
        if (x == null) {
            return SleepUtils.getEmptyScalar();
        }
        Scalar temp = new Scalar();
        temp.setValue(new StringValue(x));
        return temp;
    }

    public static Scalar getScalar(Object x) {
        if (x == null) {
            return SleepUtils.getEmptyScalar();
        }
        Scalar temp = new Scalar();
        temp.setValue(new ObjectValue(x));
        return temp;
    }

    public static Scalar getScalar(boolean x) {
        if (x) {
            return SleepUtils.getScalar(1);
        }
        return SleepUtils.getEmptyScalar();
    }

    public static boolean isTrueScalar(Scalar value) {
        return value.getArray() != null || value.getHash() != null || ((Object)value.getActualValue()).toString().length() != 0 && !"0".equals(((Object)value.getActualValue()).toString());
    }
}

