/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Stack;
import sleep.bridges.DefaultVariable;
import sleep.bridges.SleepClosure;
import sleep.interfaces.Variable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;

public class ScriptVariables
implements Serializable {
    protected Variable global;
    protected LinkedList closure;
    protected LinkedList locals;
    protected Stack marks;

    public void beginToplevel(LinkedList l) {
        this.marks.push(this.locals);
        this.locals = l;
    }

    public LinkedList leaveToplevel() {
        LinkedList scopes = this.locals;
        this.locals = (LinkedList)this.marks.pop();
        return scopes;
    }

    public boolean haveMoreLocals() {
        return this.locals.size() > 1;
    }

    public ScriptVariables() {
        this(new DefaultVariable());
    }

    public ScriptVariables(Variable aVariableClass) {
        this.global = aVariableClass;
        this.closure = new LinkedList();
        this.locals = new LinkedList();
        this.marks = new Stack();
    }

    public void putScalar(String key, Scalar value) {
        this.global.putScalar(key, value);
    }

    public Scalar getScalar(String key) {
        return this.getScalar(key, null);
    }

    public Variable getScalarLevel(String key, ScriptInstance i) {
        Variable temp = this.getLocalVariables();
        if (temp != null && temp.scalarExists(key)) {
            return temp;
        }
        temp = this.getClosureVariables();
        if (temp != null && temp.scalarExists(key)) {
            return temp;
        }
        temp = this.getGlobalVariables();
        if (temp.scalarExists(key)) {
            return temp;
        }
        return null;
    }

    public Scalar getScalar(String key, ScriptInstance i) {
        Variable temp = this.getScalarLevel(key, i);
        if (temp != null) {
            return temp.getScalar(key);
        }
        return null;
    }

    public void setScalarLevel(String key, Scalar value, Variable level) {
        level.putScalar(key, value);
    }

    public Variable getLocalVariables() {
        if (this.locals.size() == 0) {
            return null;
        }
        return (Variable)this.locals.getFirst();
    }

    public Variable getClosureVariables() {
        if (this.closure.size() == 0) {
            return null;
        }
        return (Variable)this.closure.getFirst();
    }

    public Variable getGlobalVariables() {
        return this.global;
    }

    public Variable getClosureVariables(SleepClosure closure) {
        return closure.getVariables();
    }

    public void setClosureVariables(SleepClosure closure, Variable variables) {
        closure.setVariables(variables);
    }

    public void pushClosureLevel(Variable variables) {
        this.closure.addFirst(variables);
    }

    public void popClosureLevel() {
        this.closure.removeFirst();
    }

    public void pushLocalLevel(Variable localVariables) {
        this.locals.addFirst(localVariables);
    }

    public void pushLocalLevel() {
        this.locals.addFirst(this.global.createLocalVariableContainer());
    }

    public void popLocalLevel() {
        this.locals.removeFirst();
    }
}

