/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import sleep.bridges.BasicIO;
import sleep.bridges.BasicNumbers;
import sleep.bridges.BasicStrings;
import sleep.bridges.BasicUtilities;
import sleep.bridges.DefaultEnvironment;
import sleep.bridges.DefaultVariable;
import sleep.bridges.FileSystemBridge;
import sleep.bridges.RegexBridge;
import sleep.bridges.TimeDateBridge;
import sleep.engine.Block;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Loadable;
import sleep.parser.Parser;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.taint.TaintModeGeneratedSteps;
import sleep.taint.TaintUtils;

public class ScriptLoader {
    protected static Map BLOCK_CACHE = null;
    protected LinkedList loadedScripts = new LinkedList();
    protected Map scripts = new HashMap();
    protected LinkedList bridgesg = new LinkedList();
    protected LinkedList bridgess = new LinkedList();
    protected LinkedList paths;
    protected boolean disableConversions = false;
    private static CharsetDecoder decoder = null;
    private String charset = null;

    private Block retrieveCacheEntry(String name) {
        if (BLOCK_CACHE != null && BLOCK_CACHE.containsKey(name)) {
            Object[] temp = (Object[])BLOCK_CACHE.get(name);
            return (Block)temp[0];
        }
        return null;
    }

    private static boolean isCacheHit(String name) {
        return BLOCK_CACHE != null && BLOCK_CACHE.containsKey(name);
    }

    public void touch(String name, long lastModifiedTime) {
        Object[] temp;
        long loaded;
        if (BLOCK_CACHE != null && BLOCK_CACHE.containsKey(name) && lastModifiedTime > (loaded = ((Long)(temp = (Object[])BLOCK_CACHE.get(name))[1]).longValue())) {
            BLOCK_CACHE.remove(name);
        }
    }

    public ScriptLoader() {
        this.initDefaultBridges();
    }

    public Map setGlobalCache(boolean setting) {
        if (setting && BLOCK_CACHE == null) {
            BLOCK_CACHE = Collections.synchronizedMap(new HashMap());
        }
        if (!setting) {
            BLOCK_CACHE = null;
        }
        return BLOCK_CACHE;
    }

    protected void initDefaultBridges() {
        this.addGlobalBridge(new BasicNumbers());
        this.addGlobalBridge(new BasicStrings());
        this.addGlobalBridge(new BasicUtilities());
        this.addGlobalBridge(new BasicIO());
        this.addGlobalBridge(new FileSystemBridge());
        this.addGlobalBridge(new DefaultEnvironment());
        this.addGlobalBridge(new DefaultVariable());
        this.addGlobalBridge(new RegexBridge());
        this.addGlobalBridge(new TimeDateBridge());
    }

    public void addGlobalBridge(Loadable l) {
        this.bridgesg.add(l);
    }

    public void addSpecificBridge(Loadable l) {
        this.bridgess.add(l);
    }

    public Map getScriptsByKey() {
        return this.scripts;
    }

    public boolean isLoaded(String name) {
        return this.scripts.containsKey(name);
    }

    public ScriptEnvironment getFirstScriptEnvironment() {
        if (this.loadedScripts.size() > 0) {
            ScriptInstance si = (ScriptInstance)this.loadedScripts.getFirst();
            return si.getScriptEnvironment();
        }
        return null;
    }

    public LinkedList getScripts() {
        return this.loadedScripts;
    }

    private void inProcessScript(String name, ScriptInstance si) {
        si.setName(name);
        Iterator i = this.bridgess.iterator();
        while (i.hasNext()) {
            ((Loadable)i.next()).scriptLoaded(si);
        }
        if (si.getScriptEnvironment().getEnvironment().get("(isloaded)") != this) {
            i = this.bridgesg.iterator();
            while (i.hasNext()) {
                ((Loadable)i.next()).scriptLoaded(si);
            }
            si.getScriptEnvironment().getEnvironment().put("(isloaded)", this);
        }
        if (!name.equals("<interact mode>")) {
            this.loadedScripts.add(si);
            this.scripts.put(name, si);
        }
    }

    public ScriptInstance loadSerialized(File script, Hashtable env) throws IOException, ClassNotFoundException {
        File bin = new File(script.getAbsolutePath() + ".bin");
        if (bin.exists() && (!script.exists() || script.lastModified() < bin.lastModified())) {
            return this.loadSerialized(script.getName(), new FileInputStream(bin), env);
        }
        ScriptInstance si = this.loadScript(script, env);
        ScriptLoader.saveSerialized(si);
        return si;
    }

    public ScriptInstance loadSerialized(String name, InputStream stream, Hashtable env) throws IOException, ClassNotFoundException {
        ObjectInputStream p = new ObjectInputStream(stream);
        Block block = (Block)p.readObject();
        return this.loadScript(name, block, env);
    }

    public static void saveSerialized(ScriptInstance si) throws IOException {
        ScriptLoader.saveSerialized(si, new FileOutputStream(si.getName() + ".bin"));
    }

    public static void saveSerialized(ScriptInstance si, OutputStream stream) throws IOException {
        ObjectOutputStream o = new ObjectOutputStream(stream);
        o.writeObject(si.getRunnableBlock());
    }

    public ScriptInstance loadScript(String name, Block code, Hashtable env) {
        ScriptInstance si = new ScriptInstance(env);
        si.installBlock(code);
        this.inProcessScript(name, si);
        return si;
    }

    public ScriptInstance loadScript(String name, String code, Hashtable env) throws YourCodeSucksException {
        return this.loadScript(name, this.compileScript(name, code), env);
    }

    public Block compileScript(String name, InputStream stream) throws YourCodeSucksException, IOException {
        if (ScriptLoader.isCacheHit(name)) {
            stream.close();
            return this.retrieveCacheEntry(name);
        }
        StringBuffer code = new StringBuffer(8192);
        BufferedReader in = new BufferedReader(this.getInputStreamReader(stream));
        String s = in.readLine();
        while (s != null) {
            code.append("\n");
            code.append(s);
            s = in.readLine();
        }
        in.close();
        stream.close();
        return this.compileScript(name, code.toString());
    }

    public Block compileScript(File file) throws IOException, YourCodeSucksException {
        this.touch(file.getAbsolutePath(), file.lastModified());
        return this.compileScript(file.getAbsolutePath(), new FileInputStream(file));
    }

    public Block compileScript(String fileName) throws IOException, YourCodeSucksException {
        return this.compileScript(new File(fileName));
    }

    public Block compileScript(String name, String code) throws YourCodeSucksException {
        if (ScriptLoader.isCacheHit(name)) {
            return this.retrieveCacheEntry(name);
        }
        Parser temp = new Parser(name, code);
        if (TaintUtils.isTaintMode()) {
            temp.setCodeFactory(new TaintModeGeneratedSteps());
        }
        temp.parse();
        if (BLOCK_CACHE != null) {
            BLOCK_CACHE.put(name, new Object[]{temp.getRunnableBlock(), new Long(System.currentTimeMillis())});
        }
        return temp.getRunnableBlock();
    }

    public ScriptInstance loadScript(String name, InputStream stream) throws YourCodeSucksException, IOException {
        return this.loadScript(name, stream, null);
    }

    public ScriptInstance loadScript(String name, InputStream stream, Hashtable env) throws YourCodeSucksException, IOException {
        return this.loadScript(name, this.compileScript(name, stream), env);
    }

    public ScriptInstance loadScript(String fileName) throws IOException, YourCodeSucksException {
        return this.loadScript(new File(fileName), null);
    }

    public ScriptInstance loadScript(String fileName, Hashtable env) throws IOException, YourCodeSucksException {
        return this.loadScript(new File(fileName), env);
    }

    public ScriptInstance loadScript(File file, Hashtable env) throws IOException, YourCodeSucksException {
        ScriptInstance script = this.loadScript(file.getAbsolutePath(), new FileInputStream(file), env);
        script.associateFile(file);
        return script;
    }

    public ScriptInstance loadScript(File file) throws IOException, YourCodeSucksException {
        return this.loadScript(file, null);
    }

    public void unloadScript(String filename) {
        this.unloadScript((ScriptInstance)this.scripts.get(filename));
    }

    public void unloadScript(ScriptInstance script) {
        Loadable temp;
        if (BLOCK_CACHE != null) {
            BLOCK_CACHE.remove(script.getName());
        }
        this.loadedScripts.remove(script);
        this.scripts.remove(script.getName());
        script.setUnloaded();
        Iterator i = this.bridgess.iterator();
        while (i.hasNext()) {
            temp = (Loadable)i.next();
            temp.scriptUnloaded(script);
        }
        i = this.bridgesg.iterator();
        while (i.hasNext()) {
            temp = (Loadable)i.next();
            temp.scriptUnloaded(script);
        }
    }

    public Set getScriptsToUnload(Set configured) {
        LinkedHashSet unload = new LinkedHashSet();
        Set loaded = this.scripts.keySet();
        unload.addAll(loaded);
        unload.removeAll(configured);
        return unload;
    }

    public Set getScriptsToLoad(Set configured) {
        LinkedHashSet load = new LinkedHashSet();
        Set loaded = this.scripts.keySet();
        load.addAll(configured);
        load.removeAll(loaded);
        return load;
    }

    public void setCharsetConversion(boolean b) {
        this.disableConversions = !b;
    }

    public boolean isCharsetConversions() {
        return !this.disableConversions;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    private InputStreamReader getInputStreamReader(InputStream in) {
        if (this.disableConversions) {
            if (decoder == null) {
                decoder = new NoConversion();
            }
            return new InputStreamReader(in, decoder);
        }
        if (this.charset != null) {
            try {
                return new InputStreamReader(in, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return new InputStreamReader(in);
    }

    private static class NoConversion
    extends CharsetDecoder {
        public NoConversion() {
            super(null, 1.0f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            int mark2 = in.position();
            try {
                while (in.hasRemaining()) {
                    if (!out.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    int index = in.get();
                    if (index >= 0) {
                        out.put((char)index);
                    } else {
                        index = 256 + index;
                        out.put((char)index);
                    }
                    ++mark2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                in.position(mark2);
            }
        }
    }
}

