/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.SleepClosure;
import sleep.bridges.io.IOObject;
import sleep.engine.Block;
import sleep.error.RuntimeWarningWatcher;
import sleep.error.ScriptWarning;
import sleep.interfaces.Function;
import sleep.interfaces.Variable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class ScriptInstance
implements Serializable,
Runnable {
    protected String name = "Script";
    protected boolean loaded;
    protected LinkedList watchers = new LinkedList();
    protected ScriptEnvironment environment;
    protected ScriptVariables variables;
    protected SleepClosure script;
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_SHOW_ERRORS = 1;
    public static final int DEBUG_SHOW_WARNINGS = 2;
    public static final int DEBUG_REQUIRE_STRICT = 4;
    public static final int DEBUG_TRACE_CALLS = 8;
    public static final int DEBUG_TRACE_PROFILE_ONLY = 24;
    protected static final int DEBUG_TRACE_SUPPRESS = 16;
    public static final int DEBUG_THROW_WARNINGS = 34;
    public static final int DEBUG_TRACE_LOGIC = 64;
    public static final int DEBUG_TRACE_TAINT = 128;
    protected int debug = 1;
    protected long loadTime = System.currentTimeMillis();
    protected List sourceFiles = new LinkedList();
    protected IOObject parent = null;

    public void associateFile(File f) {
        if (f.exists()) {
            this.sourceFiles.add(f);
        }
    }

    public boolean hasChanged() {
        Iterator i = this.sourceFiles.iterator();
        while (i.hasNext()) {
            File temp = (File)i.next();
            if (temp.lastModified() <= this.loadTime) continue;
            return true;
        }
        return false;
    }

    public void setDebugFlags(int options) {
        this.debug = options;
    }

    public int getDebugFlags() {
        return this.debug;
    }

    public ScriptInstance(Hashtable environmentToShare) {
        this(null, environmentToShare);
    }

    public ScriptInstance(Variable varContainerToUse, Hashtable environmentToShare) {
        if (environmentToShare == null) {
            environmentToShare = new Hashtable();
        }
        this.variables = varContainerToUse == null ? new ScriptVariables() : new ScriptVariables(varContainerToUse);
        this.environment = new ScriptEnvironment(environmentToShare, this);
        this.loaded = true;
    }

    public void installBlock(Block _script) {
        this.script = new SleepClosure(this, _script);
    }

    public ScriptInstance() {
        this(null, null);
    }

    public ScriptEnvironment getScriptEnvironment() {
        return this.environment;
    }

    public void setScriptVariables(ScriptVariables v) {
        this.variables = v;
    }

    public ScriptVariables getScriptVariables() {
        return this.variables;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String sn) {
        this.name = sn;
    }

    public Scalar runScript() {
        return SleepUtils.runCode(this.script, null, this, null);
    }

    public void recordStackFrame(String description, String source, int lineNumber) {
        LinkedList<SleepStackElement> strace = (LinkedList<SleepStackElement>)this.getScriptEnvironment().getEnvironment().get("%strace%");
        if (strace == null) {
            strace = new LinkedList<SleepStackElement>();
            this.getScriptEnvironment().getEnvironment().put("%strace%", strace);
        }
        SleepStackElement stat = new SleepStackElement();
        stat.sourcefile = source;
        stat.description = description;
        stat.lineNumber = lineNumber;
        strace.add(0, stat);
    }

    public File cwd() {
        if (!this.getMetadata().containsKey("__CWD__")) {
            this.chdir(null);
        }
        return (File)this.getMetadata().get("__CWD__");
    }

    public void chdir(File f) {
        if (f == null) {
            f = new File("");
        }
        this.getMetadata().put("__CWD__", f.getAbsoluteFile());
    }

    public void recordStackFrame(String description, int lineNumber) {
        this.recordStackFrame(description, this.getScriptEnvironment().getCurrentSource(), lineNumber);
    }

    public void clearStackTrace() {
        LinkedList strace = new LinkedList();
        this.getScriptEnvironment().getEnvironment().put("%strace%", strace);
    }

    public List getStackTrace() {
        LinkedList strace = (LinkedList)this.getScriptEnvironment().getEnvironment().get("%strace%");
        this.clearStackTrace();
        if (strace == null) {
            strace = new LinkedList();
        }
        return strace;
    }

    public long total() {
        Long total = (Long)this.getMetadata().get("%total%");
        return total == null ? 0L : total;
    }

    public void collect(String function2, int lineNo, long ticks2) {
        ProfilerStatistic stats;
        HashMap<String, ProfilerStatistic> statistics = (HashMap<String, ProfilerStatistic>)this.getMetadata().get("%statistics%");
        Long total = (Long)this.getMetadata().get("%total%");
        if (statistics == null) {
            statistics = new HashMap<String, ProfilerStatistic>();
            total = new Long(0L);
            this.getMetadata().put("%statistics%", statistics);
            this.getMetadata().put("%total%", total);
        }
        if ((stats = (ProfilerStatistic)statistics.get(function2)) == null) {
            stats = new ProfilerStatistic();
            stats.functionName = function2;
            statistics.put(function2, stats);
        }
        stats.ticks += ticks2;
        ++stats.calls;
        this.getMetadata().put("%total%", new Long(total + ticks2));
    }

    public boolean isProfileOnly() {
        return (this.getDebugFlags() & 0x18) == 24;
    }

    public List getProfilerStatistics() {
        Map statistics = (Map)this.getMetadata().get("%statistics%");
        if (statistics != null) {
            LinkedList values = new LinkedList(statistics.values());
            Collections.sort(values);
            return values;
        }
        return new LinkedList();
    }

    public Map getMetadata() {
        Scalar container = this.getScriptVariables().getGlobalVariables().getScalar("__meta__");
        Map meta = null;
        if (container == null) {
            meta = Collections.synchronizedMap(new HashMap());
            this.getScriptVariables().getGlobalVariables().putScalar("__meta__", SleepUtils.getScalar(meta));
        } else {
            meta = (Map)container.objectValue();
        }
        return meta;
    }

    public void printProfileStatistics(OutputStream out) {
        PrintWriter pout = new PrintWriter(out, true);
        Iterator i = this.getProfilerStatistics().iterator();
        while (i.hasNext()) {
            String temp = i.next().toString();
            pout.println(temp);
        }
    }

    public ScriptInstance fork() {
        ScriptInstance si = new ScriptInstance(this.variables.getGlobalVariables().createInternalVariableContainer(), this.environment.getEnvironment());
        si.setName(this.getName());
        si.setDebugFlags(this.getDebugFlags());
        si.watchers = this.watchers;
        si.getScriptVariables().getGlobalVariables().putScalar("__meta__", SleepUtils.getScalar(this.getMetadata()));
        return si;
    }

    public void run() {
        Scalar temp = this.runScript();
        if (this.parent != null) {
            this.parent.setToken(temp);
        }
    }

    public void setParent(IOObject p) {
        this.parent = p;
    }

    public Block getRunnableBlock() {
        return this.script.getRunnableCode();
    }

    public SleepClosure getRunnableScript() {
        return this.script;
    }

    public Scalar callFunction(String funcName, Stack parameters) {
        Function myfunction = this.getScriptEnvironment().getFunction(funcName);
        if (myfunction == null) {
            return null;
        }
        Scalar evil = myfunction.evaluate(funcName, this, parameters);
        this.getScriptEnvironment().resetEnvironment();
        return evil;
    }

    public void setUnloaded() {
        this.loaded = false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void addWarningWatcher(RuntimeWarningWatcher w) {
        this.watchers.add(w);
    }

    public void removeWarningWatcher(RuntimeWarningWatcher w) {
        this.watchers.remove(w);
    }

    public void fireWarning(String message, int line) {
        this.fireWarning(message, line, false);
    }

    public void fireWarning(String message, int line, boolean isTrace) {
        if (!(this.debug == 0 || isTrace && (this.getDebugFlags() & 0x10) == 16)) {
            ScriptWarning temp = new ScriptWarning(this, message, line, isTrace);
            Iterator i = this.watchers.iterator();
            while (i.hasNext()) {
                ((RuntimeWarningWatcher)i.next()).processScriptWarning(temp);
            }
        }
    }

    public static class ProfilerStatistic
    implements Comparable,
    Serializable {
        public String functionName;
        public long ticks = 0L;
        public long calls = 0L;

        public int compareTo(Object o) {
            return (int)(((ProfilerStatistic)o).ticks - this.ticks);
        }

        public String toString() {
            return (double)this.ticks / 1000.0 + "s " + this.calls + " " + this.functionName;
        }
    }

    public static class SleepStackElement
    implements Serializable {
        public String sourcefile;
        public String description;
        public int lineNumber;

        public String toString() {
            return "   " + new File(this.sourcefile).getName() + ":" + this.lineNumber + " " + this.description;
        }
    }
}

