/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import sleep.engine.Block;
import sleep.engine.Step;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Environment;
import sleep.interfaces.FilterEnvironment;
import sleep.interfaces.Function;
import sleep.interfaces.Operator;
import sleep.interfaces.Predicate;
import sleep.interfaces.PredicateEnvironment;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class ScriptEnvironment
implements Serializable {
    protected ScriptInstance self;
    protected Stack environmentStack;
    protected Hashtable environment;
    protected Object errorMessage = null;
    protected Stack context = new Stack();
    protected Stack contextStack = new Stack();
    protected HashMap metadata = new HashMap();
    protected Stack metaStack = new Stack();
    protected ExceptionContext currentHandler = null;
    protected Stack exhandlers = new Stack();
    protected boolean moreHandlers = false;
    public static final int FLOW_CONTROL_NONE = 0;
    public static final int FLOW_CONTROL_RETURN = 1;
    public static final int FLOW_CONTROL_BREAK = 2;
    public static final int FLOW_CONTROL_CONTINUE = 4;
    public static final int FLOW_CONTROL_YIELD = 8;
    public static final int FLOW_CONTROL_THROW = 16;
    public static final int FLOW_CONTROL_DEBUG = 32;
    public static final int FLOW_CONTROL_CALLCC = 72;
    public static final int FLOW_CONTROL_PASS = 128;
    protected String debugString = "";
    protected Scalar rv = null;
    protected int request = 0;
    protected Stack sources = new Stack();
    protected ArrayList frames = new ArrayList(10);
    protected int findex = -1;

    public ScriptEnvironment() {
        this.self = null;
        this.environment = null;
        this.environmentStack = new Stack();
    }

    public ScriptEnvironment(Hashtable env, ScriptInstance myscript) {
        this.self = myscript;
        this.environment = env;
        this.environmentStack = new Stack();
    }

    public ScriptInstance getScriptInstance() {
        return this.self;
    }

    public void flagError(Object message) {
        this.errorMessage = message;
        if ((this.getScriptInstance().getDebugFlags() & 2) == 2) {
            if ((this.getScriptInstance().getDebugFlags() & 0x22) == 34) {
                this.flagReturn(this.checkError(), 16);
            } else {
                this.showDebugMessage("checkError(): " + message);
            }
        }
    }

    public Scalar checkError() {
        Scalar temp = SleepUtils.getScalar(this.errorMessage);
        this.errorMessage = null;
        return temp;
    }

    public ScriptVariables getScriptVariables() {
        return this.getScriptInstance().getScriptVariables();
    }

    public Scalar getScalar(String key) {
        return this.getScriptVariables().getScalar(key, this.getScriptInstance());
    }

    public void putScalar(String key, Scalar value) {
        this.getScriptVariables().putScalar(key, value);
    }

    public Block getBlock(String name) {
        return (Block)this.getEnvironment().get("^" + name);
    }

    public Function getFunction(String func) {
        return (Function)this.getEnvironment().get(func);
    }

    public Environment getFunctionEnvironment(String env) {
        return (Environment)this.getEnvironment().get(env);
    }

    public PredicateEnvironment getPredicateEnvironment(String env) {
        return (PredicateEnvironment)this.getEnvironment().get(env);
    }

    public FilterEnvironment getFilterEnvironment(String env) {
        return (FilterEnvironment)this.getEnvironment().get(env);
    }

    public Predicate getPredicate(String name) {
        return (Predicate)this.getEnvironment().get(name);
    }

    public Operator getOperator(String oper) {
        return (Operator)this.getEnvironment().get(oper);
    }

    public Hashtable getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Hashtable h) {
        this.environment = h;
    }

    public Stack getEnvironmentStack() {
        return this.environmentStack;
    }

    public String toString() {
        StringBuffer temp = new StringBuffer();
        temp.append("ScriptInstance -- " + this.getScriptInstance());
        temp.append("Misc Environment:\n");
        temp.append(this.getEnvironment().toString());
        temp.append("\nEnvironment Stack:\n");
        temp.append(this.getEnvironmentStack().toString());
        temp.append("Return Stuff: " + this.rv);
        return temp.toString();
    }

    public void loadContext(Stack _context, HashMap _metadata) {
        this.contextStack.push(this.context);
        this.metaStack.push(this.metadata);
        this.context = _context;
        this.metadata = _metadata;
    }

    public void setContextMetadata(Object key, Object value) {
        if (value == null) {
            this.metadata.remove(key);
        } else {
            this.metadata.put(key, value);
        }
    }

    public Object getContextMetadata(Object key) {
        return this.metadata.get(key);
    }

    public Object getContextMetadata(Object key, Object default_value) {
        Object value = this.metadata.get(key);
        if (value == null) {
            return default_value;
        }
        return this.metadata.get(key);
    }

    public void addToContext(Block b, Step s) {
        Context temp = new Context();
        temp.block = b;
        temp.last = s;
        if (this.isResponsible(b)) {
            temp.handler = this.popExceptionContext();
            Iterator i = this.context.iterator();
            while (i.hasNext()) {
                Context c = (Context)i.next();
                c.moreHandlers = true;
            }
        } else {
            temp.moreHandlers = this.moreHandlers;
        }
        this.context.add(temp);
    }

    public Scalar evaluateOldContext() {
        Scalar rv = SleepUtils.getEmptyScalar();
        Stack cstack = this.context;
        this.context = new Stack();
        Iterator i = cstack.iterator();
        while (i.hasNext()) {
            Context temp = (Context)i.next();
            if (temp.handler != null) {
                this.installExceptionHandler(temp.handler);
            }
            this.moreHandlers = temp.moreHandlers;
            rv = temp.block.evaluate(this, temp.last);
            if (!this.isReturn() || !this.isYield()) continue;
            while (i.hasNext()) {
                this.context.add(i.next());
            }
        }
        this.moreHandlers = false;
        return rv;
    }

    public Stack saveContext() {
        Stack cstack = this.context;
        this.context = (Stack)this.contextStack.pop();
        this.metadata = (HashMap)this.metaStack.pop();
        return cstack;
    }

    public boolean isExceptionHandlerInstalled() {
        return this.currentHandler != null || this.moreHandlers;
    }

    public boolean isResponsible(Block block) {
        return this.currentHandler != null && this.currentHandler.owner == block;
    }

    public void installExceptionHandler(ExceptionContext exc) {
        if (this.currentHandler != null) {
            this.exhandlers.push(this.currentHandler);
        }
        this.currentHandler = exc;
    }

    public void installExceptionHandler(Block owner, Block handler, String varname) {
        ExceptionContext c = new ExceptionContext();
        c.owner = owner;
        c.handler = handler;
        c.varname = varname;
        this.installExceptionHandler(c);
    }

    public Scalar getExceptionMessage() {
        this.request &= 0xFFFFFFEF;
        Scalar temp = this.rv;
        this.rv = null;
        return temp;
    }

    public Block getExceptionHandler() {
        this.request &= 0xFFFFFFEF;
        Block doit = this.currentHandler.handler;
        Scalar temp = this.getScriptVariables().getScalar(this.currentHandler.varname, this.getScriptInstance());
        if (temp != null) {
            temp.setValue(this.rv);
        } else {
            this.putScalar(this.currentHandler.varname, this.rv);
        }
        this.rv = null;
        return doit;
    }

    public ExceptionContext popExceptionContext() {
        ExceptionContext old = this.currentHandler;
        this.currentHandler = this.exhandlers.isEmpty() ? null : (ExceptionContext)this.exhandlers.pop();
        return old;
    }

    public boolean isThrownValue() {
        return (this.request & 0x10) == 16;
    }

    public boolean isDebugInterrupt() {
        return (this.request & 0x20) == 32;
    }

    public boolean isYield() {
        return (this.request & 8) == 8;
    }

    public boolean isCallCC() {
        return (this.request & 0x48) == 72;
    }

    public boolean isPassControl() {
        return (this.request & 0x80) == 128;
    }

    public Scalar getReturnValue() {
        return this.rv;
    }

    public boolean isReturn() {
        return this.request != 0;
    }

    public int getFlowControlRequest() {
        return this.request;
    }

    public String getDebugString() {
        this.request &= 0xFFFFFFDF;
        return this.debugString;
    }

    public void showDebugMessage(String message) {
        this.request |= 0x20;
        this.debugString = message;
    }

    public void flagReturn(Scalar value, int type_of_flow) {
        if (value == null) {
            value = SleepUtils.getEmptyScalar();
        }
        this.rv = value;
        this.request = type_of_flow;
    }

    public void resetEnvironment() {
        this.errorMessage = null;
        this.request = 0;
        this.rv = null;
        this.getScriptInstance().clearStackTrace();
    }

    public void clearReturn() {
        this.request = 0 | this.request & 0xB0;
        if (!this.isThrownValue() && !this.isPassControl()) {
            this.rv = null;
        }
    }

    public void pushSource(String s) {
        this.sources.push(s);
    }

    public String getCurrentSource() {
        if (!this.sources.isEmpty()) {
            return this.sources.peek() + "";
        }
        return "unknown";
    }

    public void popSource() {
        this.sources.pop();
    }

    public int markFrame() {
        return this.findex;
    }

    public void cleanFrame(int mark2) {
        while (this.findex > mark2) {
            this.KillFrame();
        }
    }

    public Stack getCurrentFrame() {
        return (Stack)this.frames.get(this.findex);
    }

    public void FrameResult(Scalar value) {
        this.KillFrame();
        if (this.findex >= 0) {
            this.getCurrentFrame().push(value);
        }
    }

    public boolean hasFrame() {
        return this.findex >= 0;
    }

    public void KillFrame() {
        this.getCurrentFrame().clear();
        --this.findex;
    }

    public void CreateFrame(Stack frame) {
        if (frame == null) {
            frame = new Stack();
        }
        if (this.findex + 1 >= this.frames.size()) {
            this.frames.add(frame);
        } else {
            this.frames.set(this.findex + 1, frame);
        }
        ++this.findex;
    }

    public void CreateFrame() {
        if (this.findex + 1 >= this.frames.size()) {
            this.frames.add(new Stack());
        }
        ++this.findex;
    }

    public Scalar evaluateStatement(String code) throws YourCodeSucksException {
        return SleepUtils.runCode(SleepUtils.ParseCode(code), this);
    }

    public boolean evaluatePredicate(String code) throws YourCodeSucksException {
        code = "if (" + code + ") { return 1; } else { return $null; }";
        return SleepUtils.runCode(SleepUtils.ParseCode(code), this).intValue() == 1;
    }

    public Scalar evaluateExpression(String code) throws YourCodeSucksException {
        code = "return (" + code + ");";
        return SleepUtils.runCode(SleepUtils.ParseCode(code), this);
    }

    public Scalar evaluateParsedLiteral(String code) throws YourCodeSucksException {
        code = "return \"" + code + "\";";
        return SleepUtils.runCode(SleepUtils.ParseCode(code), this);
    }

    protected static class ExceptionContext
    implements Serializable {
        public Block owner;
        public String varname;
        public Block handler;

        protected ExceptionContext() {
        }
    }

    protected static class Context
    implements Serializable {
        public Block block;
        public Step last;
        public ExceptionContext handler;
        public boolean moreHandlers;

        protected Context() {
        }
    }
}

