/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import sleep.engine.types.ObjectValue;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScalarType;
import sleep.runtime.SleepUtils;

public class Scalar
implements Serializable {
    protected ScalarType value = null;
    protected ScalarArray array = null;
    protected ScalarHash hash = null;

    public ScalarType getActualValue() {
        return this.value;
    }

    public ScalarType getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.array != null) {
            return SleepUtils.getScalar(SleepUtils.describe(this)).getValue();
        }
        if (this.hash != null) {
            return SleepUtils.getScalar(SleepUtils.describe(this)).getValue();
        }
        return null;
    }

    public String stringValue() {
        return ((Object)this.getValue()).toString();
    }

    public int intValue() {
        return this.getValue().intValue();
    }

    public double doubleValue() {
        return this.getValue().doubleValue();
    }

    public long longValue() {
        return this.getValue().longValue();
    }

    public Object objectValue() {
        if (this.array != null) {
            return this.array;
        }
        if (this.hash != null) {
            return this.hash;
        }
        return this.value.objectValue();
    }

    public ScalarArray getArray() {
        return this.array;
    }

    public ScalarHash getHash() {
        return this.hash;
    }

    public void setValue(ScalarType _value) {
        this.value = _value.copyValue();
        this.array = null;
        this.hash = null;
    }

    public void setValue(ScalarArray _array) {
        this.value = null;
        this.array = _array;
        this.hash = null;
    }

    public void setValue(ScalarHash _hash) {
        this.value = null;
        this.array = null;
        this.hash = _hash;
    }

    public Object identity() {
        if (this.getArray() != null) {
            return this.array;
        }
        if (this.getHash() != null) {
            return this.hash;
        }
        if (this.value.getType() == ObjectValue.class) {
            return this.objectValue();
        }
        return this.toString();
    }

    public boolean sameAs(Scalar other) {
        if (this.getArray() != null && other.getArray() != null && this.getArray() == other.getArray()) {
            return true;
        }
        if (this.getHash() != null && other.getHash() != null && this.getHash() == other.getHash()) {
            return true;
        }
        if (this.getActualValue() != null && other.getActualValue() != null) {
            if (this.getActualValue().getType() == ObjectValue.class || other.getActualValue().getType() == ObjectValue.class) {
                return this.objectValue() == other.objectValue();
            }
            return this.identity().equals(other.identity());
        }
        return false;
    }

    public String toString() {
        return this.stringValue();
    }

    public void setValue(Scalar newValue) {
        if (newValue == null) {
            return;
        }
        if (newValue.getArray() != null) {
            this.setValue(newValue.getArray());
            return;
        }
        if (newValue.getHash() != null) {
            this.setValue(newValue.getHash());
            return;
        }
        if (newValue.getValue() != null) {
            this.setValue(newValue.getValue());
            return;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (SleepUtils.isEmptyScalar(this)) {
            out.writeObject(null);
        } else {
            out.writeObject(this.value);
        }
        out.writeObject(this.array);
        out.writeObject(this.hash);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = (ScalarType)in.readObject();
        this.array = (ScalarArray)in.readObject();
        this.hash = (ScalarHash)in.readObject();
        if (this.value == null && this.array == null && this.hash == null) {
            this.setValue(SleepUtils.getEmptyScalar());
        }
    }
}

