/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import sleep.engine.ObjectUtilities;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;

public class CollectionWrapper
implements ScalarArray {
    protected Collection values;
    protected Object[] array = null;

    public ScalarArray sublist(int begin, int end) {
        LinkedList temp = new LinkedList();
        Iterator i = this.values.iterator();
        for (int count = 0; i.hasNext() && count < end; ++count) {
            if (count < begin) continue;
            temp.add(i.next());
        }
        return new CollectionWrapper(temp);
    }

    public CollectionWrapper(Collection _values) {
        this.values = _values;
    }

    public String toString() {
        return "(read-only array: " + this.values.toString() + ")";
    }

    public Scalar pop() {
        throw new RuntimeException("array is read-only");
    }

    public void sort(Comparator compare) {
        throw new RuntimeException("array is read-only");
    }

    public Scalar push(Scalar value) {
        throw new RuntimeException("array is read-only");
    }

    public int size() {
        return this.values.size();
    }

    public Scalar remove(int index) {
        throw new RuntimeException("array is read-only");
    }

    public Scalar getAt(int index) {
        if (this.array == null) {
            this.array = this.values.toArray();
        }
        return ObjectUtilities.BuildScalar(true, this.array[index]);
    }

    public Iterator scalarIterator() {
        return new ProxyIterator();
    }

    public Scalar add(Scalar value, int index) {
        throw new RuntimeException("array is read-only");
    }

    public void remove(Scalar value) {
        throw new RuntimeException("array is read-only");
    }

    protected class ProxyIterator
    implements Iterator {
        protected Iterator realIterator;

        public ProxyIterator() {
            this.realIterator = CollectionWrapper.this.values.iterator();
        }

        public boolean hasNext() {
            return this.realIterator.hasNext();
        }

        public Object next() {
            Object temp = this.realIterator.next();
            return ObjectUtilities.BuildScalar(true, temp);
        }

        public void remove() {
            throw new RuntimeException("array is read-only");
        }
    }
}

