/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import java.util.LinkedList;
import sleep.parser.Checkers;
import sleep.parser.LexicalAnalyzer;
import sleep.parser.Parser;
import sleep.parser.ParserConstants;
import sleep.parser.ParserUtilities;
import sleep.parser.Statement;
import sleep.parser.StringIterator;
import sleep.parser.Token;
import sleep.parser.TokenList;

public class TokenParser
implements ParserConstants {
    public static Statement ParseObject(Parser parser, TokenList data) {
        Token[] tokens = data.getTokens();
        String[] strings = data.getStrings();
        Statement myToken = new Statement();
        int idx = 0;
        if (tokens.length < 1) {
            parser.reportError("Object Access: expression is empty", new Token(data.toString(), tokens[0].getHint()));
            return null;
        }
        if (strings.length >= 2 && strings[1].equals(".")) {
            int t;
            StringBuffer token = new StringBuffer();
            for (t = 0; t < tokens.length - 1 && strings[t + 1].equals("."); t += 2) {
                token.append(strings[t]);
                token.append(".");
            }
            if (t < tokens.length) {
                token.append(strings[t]);
                ++t;
            }
            Token nToken = tokens[0].copy(token.toString());
            TokenList nList = new TokenList();
            nList.add(nToken);
            while (t < tokens.length) {
                nList.add(tokens[t]);
                ++t;
            }
            return TokenParser.ParseObject(parser, nList);
        }
        if (strings.length >= 3 && strings[2].equals(".")) {
            int t;
            StringBuffer token = new StringBuffer();
            TokenList nList = new TokenList();
            nList.add(tokens[0]);
            for (t = 1; t < tokens.length - 1 && strings[t + 1].equals("."); t += 2) {
                token.append(strings[t]);
                token.append(".");
            }
            if (t < tokens.length) {
                token.append(strings[t]);
                ++t;
            }
            Token nToken = tokens[1].copy(token.toString());
            nList.add(nToken);
            while (t < tokens.length) {
                nList.add(tokens[t]);
                ++t;
            }
            return TokenParser.ParseObject(parser, nList);
        }
        if (strings.length == 1) {
            myToken.setType(446);
            myToken.add(tokens[0]);
            idx = 1;
        } else if (strings.length >= 2 && Checkers.isClosureCall(strings[0], strings[1])) {
            myToken.setType(446);
            myToken.add(tokens[0]);
            idx = 1;
        } else if (strings.length >= 2 && Checkers.isObjectNew(strings[0], strings[1])) {
            myToken.setType(441);
            myToken.add(tokens[1]);
            idx = 2;
        } else if (strings.length >= 2 && Checkers.isClassIdentifier(parser, strings[0])) {
            myToken.setType(443);
            myToken.add(tokens[0]);
            myToken.add(tokens[1]);
            idx = 2;
        } else {
            myToken.setType(442);
            myToken.add(tokens[0]);
            myToken.add(tokens[1]);
            idx = 2;
        }
        if (idx >= tokens.length) {
            return myToken;
        }
        if (!strings[idx].equals("EOT")) {
            parser.reportError("Object Access: parameter separator is :", new Token(data.toString(), tokens[0].getHint()));
            return null;
        }
        if (idx + 1 >= tokens.length) {
            parser.reportError("Object Access: can not specify empty arg list after :", new Token("[" + data.toString().substring(0, data.toString().length() - 4) + ":<null>]", tokens[0].getHint()));
            return null;
        }
        StringBuffer temp = new StringBuffer(strings[++idx]);
        ++idx;
        while (idx < tokens.length) {
            temp.append(" ");
            temp.append(strings[idx]);
            ++idx;
        }
        myToken.add(new Token(temp.toString(), tokens[idx - 1].getHint()));
        return myToken;
    }

    public static Statement ParsePredicate(Parser parser, TokenList data) {
        int check;
        Token[] tokens = data.getTokens();
        String[] strings = data.getStrings();
        Statement myToken = new Statement();
        boolean is_or = false;
        boolean is_and = false;
        int x = 0;
        if (tokens.length >= 3 && Checkers.isUniPredicate(strings[x], strings[x + 1]) && Checkers.isIndexableItem(strings[x + 1], strings[x + 2])) {
            myToken.add(tokens[x]);
            myToken.add(ParserUtilities.makeToken(strings[++x] + strings[x + 1], tokens[0]));
            x += 2;
            while (x < tokens.length) {
                myToken.add(tokens[x]);
                ++x;
            }
            return TokenParser.ParsePredicate(parser, myToken);
        }
        if (tokens.length == 3) {
            is_or = Checkers.isOrPredicate(strings[x], strings[x + 1], strings[x + 2]);
            is_and = Checkers.isAndPredicate(strings[x], strings[x + 1], strings[x + 2]);
        } else if (2 < tokens.length && (check = TokenParser.findPrecedentOperators(myToken, data, 0, "&& ||", 2)) != 0) {
            return TokenParser.ParsePredicate(parser, myToken);
        }
        if (x + 2 < tokens.length && (is_or || is_and)) {
            if (is_or) {
                myToken.setType(803);
            }
            if (is_and) {
                myToken.setType(804);
            }
            myToken.add(tokens[x]);
            myToken.add(tokens[x + 1]);
            x += 2;
        } else if (x + 2 < tokens.length && Checkers.isBiPredicate(strings[x], strings[x + 1], strings[x + 2])) {
            myToken.setType(801);
            myToken.add(tokens[x]);
            myToken.add(tokens[x + 1]);
            x += 2;
        } else if (x + 1 < tokens.length && Checkers.isUniPredicate(strings[x], strings[x + 1])) {
            myToken.setType(802);
            myToken.add(tokens[x]);
            ++x;
        } else if (Checkers.isExpression(strings[x])) {
            myToken.setType(805);
        } else {
            myToken.setType(806);
        }
        if (x < tokens.length) {
            StringBuffer temp = new StringBuffer(strings[x]);
            ++x;
            while (x < tokens.length) {
                temp.append(" ");
                temp.append(strings[x]);
                ++x;
            }
            myToken.add(new Token(temp.toString(), tokens[x - 1].getHint()));
        }
        return myToken;
    }

    protected static int findPrecedentOperators(Statement statement, TokenList data, int start, String operators, int osize) {
        String[] strings = data.getStrings();
        Token[] tokens = data.getTokens();
        for (int x = start; x < tokens.length; ++x) {
            int r;
            if (strings[x].equals("EOT")) {
                return start;
            }
            if (strings[x].length() != osize || operators.indexOf(strings[x]) <= -1) continue;
            StringBuffer lhs = new StringBuffer(strings[start]);
            for (int l = start + 1; l < x; ++l) {
                lhs.append(" ");
                lhs.append(strings[l]);
            }
            StringBuffer rhs = new StringBuffer(strings[x + 1]);
            for (r = x + 2; r < tokens.length && !strings[r].equals("EOT"); ++r) {
                rhs.append(" ");
                rhs.append(strings[r]);
            }
            statement.add(new Token(lhs.toString(), tokens[start].getHint()));
            statement.add(tokens[x]);
            statement.add(new Token(rhs.toString(), tokens[x + 1].getHint()));
            return r;
        }
        return start;
    }

    public static LinkedList ParseIdea(Parser parser, TokenList data) {
        Token[] tokens = data.getTokens();
        String[] strings = data.getStrings();
        LinkedList<Statement> value = new LinkedList<Statement>();
        for (int x = 0; x < tokens.length; ++x) {
            Statement myToken = new Statement();
            if (x + 2 < tokens.length && Checkers.isOperator(strings[x], strings[x + 1], strings[x + 2])) {
                myToken.setType(603);
                int check = TokenParser.findPrecedentOperators(myToken, data, x, "=>", 2);
                if (check != x) {
                    myToken.setType(612);
                    x = check;
                } else {
                    check = TokenParser.findPrecedentOperators(myToken, data, x, "+ - .", 1);
                    if (check == x) {
                        myToken.add(tokens[x]);
                        myToken.add(tokens[x + 1]);
                        int hint = tokens[x + 2].getHint();
                        StringBuffer otherTerms = new StringBuffer(strings[x + 2]);
                        x += 3;
                        while (x < tokens.length && !strings[x].equals("EOT")) {
                            otherTerms.append(" ");
                            otherTerms.append(strings[x]);
                            ++x;
                        }
                        myToken.add(new Token(otherTerms.toString(), hint));
                    } else {
                        x = check;
                    }
                }
            } else if (Checkers.isIndexableItem(strings[x])) {
                myToken.setType(710);
                Token[] temp = LexicalAnalyzer.CreateTerms(parser, new StringIterator(strings[x], tokens[x].getHint())).getTokens();
                int z = 0;
                if (z + 1 < temp.length && Checkers.isFunctionCall(temp[0].toString(), temp[1].toString())) {
                    myToken.add(ParserUtilities.combineTokens(temp[0], temp[1]));
                    z += 2;
                }
                while (z < temp.length) {
                    myToken.add(temp[z]);
                    ++z;
                }
            } else if (Checkers.isIndex(strings[x])) {
                myToken.setType(611);
                myToken.add(tokens[x]);
            } else if (Checkers.isFunctionCall(strings[x])) {
                myToken.setType(604);
                myToken.add(tokens[x]);
            } else if (Checkers.isIncrementHack(strings[x])) {
                myToken.setType(901);
                myToken.add(tokens[x]);
            } else if (Checkers.isDecrementHack(strings[x])) {
                myToken.setType(902);
                myToken.add(tokens[x]);
            } else if (Checkers.isVariableReference(strings[x])) {
                myToken.setType(705);
                myToken.add(tokens[x]);
            } else if (Checkers.isVariable(strings[x])) {
                myToken.setType(701);
                myToken.add(tokens[x]);
            } else if (Checkers.isExpression(strings[x])) {
                myToken.setType(601);
                myToken.add(tokens[x]);
            } else if (Checkers.isFunction(strings[x]) && Checkers.isFunctionReferenceToken(strings[x])) {
                myToken.setType(604);
                myToken.add(tokens[x]);
            } else if (Checkers.isString(strings[x])) {
                myToken.setType(605);
                myToken.add(tokens[x]);
            } else if (Checkers.isBacktick(strings[x])) {
                myToken.setType(506);
                myToken.add(tokens[x]);
            } else if (Checkers.isLiteral(strings[x])) {
                myToken.setType(606);
                myToken.add(tokens[x]);
            } else if (Checkers.isNumber(strings[x])) {
                myToken.setType(607);
                myToken.add(tokens[x]);
            } else if (Checkers.isDouble(strings[x])) {
                myToken.setType(608);
                myToken.add(tokens[x]);
            } else if (Checkers.isBoolean(strings[x])) {
                myToken.setType(609);
                myToken.add(tokens[x]);
            } else if (Checkers.isBlock(strings[x])) {
                myToken.setType(613);
                myToken.add(tokens[x]);
            } else if (Checkers.isClassLiteral(strings[x])) {
                myToken.setType(614);
                myToken.add(tokens[x]);
            } else {
                parser.reportError("Unknown expression", new Token(data.toString(), tokens[x].getHint()));
                return null;
            }
            value.add(myToken);
        }
        return value;
    }

    public static LinkedList ParseBlocks(Parser parser, TokenList data) {
        String[] strings = data.getStrings();
        Token[] tokens = data.getTokens();
        LinkedList<Statement> value = new LinkedList<Statement>();
        for (int x = 0; x < tokens.length; ++x) {
            StringBuffer newExpr;
            Statement myToken = new Statement();
            if (x + 5 < tokens.length && Checkers.isSpecialForeach(strings[x], strings[x + 1], strings[x + 2], strings[x + 3], strings[x + 4], strings[x + 5])) {
                myToken.setType(402);
                myToken.add(tokens[x]);
                myToken.add(tokens[x + 1]);
                myToken.add(tokens[x + 2]);
                myToken.add(tokens[x + 3]);
                myToken.add(tokens[x + 4]);
                myToken.add(tokens[x + 5]);
                x += 5;
            } else if (x + 4 < tokens.length && Checkers.isTryCatch(strings[x], strings[x + 1], strings[x + 2], strings[x + 3], strings[x + 4])) {
                myToken.setType(403);
                myToken.add(tokens[x]);
                myToken.add(tokens[x + 1]);
                myToken.add(tokens[x + 2]);
                myToken.add(tokens[x + 3]);
                myToken.add(tokens[x + 4]);
                x += 4;
            } else if (x + 3 < tokens.length && Checkers.isSpecialWhile(strings[x], strings[x + 1], strings[x + 2], strings[x + 3])) {
                myToken.setType(101);
                myToken.add(tokens[x]);
                myToken.add(tokens[x + 1]);
                myToken.add(tokens[x + 2]);
                myToken.add(tokens[x + 3]);
                x += 3;
            } else if (x + 3 < tokens.length && Checkers.isForeach(strings[x], strings[x + 1], strings[x + 2], strings[x + 3])) {
                myToken.setType(400);
                myToken.add(tokens[x]);
                myToken.add(tokens[x + 1]);
                myToken.add(tokens[x + 2]);
                myToken.add(tokens[x + 3]);
                x += 3;
            } else if (x + 2 < tokens.length && Checkers.isIfStatement(strings[x], strings[x + 1], strings[x + 2])) {
                myToken.setType(301);
                myToken.add(tokens[x]);
                myToken.add(tokens[x + 1]);
                myToken.add(tokens[x + 2]);
                x += 3;
                while (x + 3 < tokens.length && Checkers.isElseIfStatement(strings[x], strings[x + 1], strings[x + 2], strings[x + 3])) {
                    myToken.add(tokens[x]);
                    myToken.add(tokens[x + 1]);
                    myToken.add(tokens[x + 2]);
                    myToken.add(tokens[x + 3]);
                    x += 4;
                }
                if (x + 1 < tokens.length && Checkers.isElseStatement(strings[x], strings[x + 1])) {
                    myToken.add(tokens[x]);
                    myToken.add(tokens[x + 1]);
                    x += 2;
                }
                --x;
            } else if (x + 2 < tokens.length && Checkers.isWhile(strings[x], strings[x + 1], strings[x + 2])) {
                myToken.setType(100);
                myToken.add(tokens[x]);
                myToken.add(tokens[x + 1]);
                myToken.add(tokens[x + 2]);
                x += 2;
            } else if (x + 2 < tokens.length && Checkers.isFor(strings[x], strings[x + 1], strings[x + 2])) {
                myToken.setType(401);
                myToken.add(tokens[x]);
                myToken.add(tokens[x + 1]);
                myToken.add(tokens[x + 2]);
                x += 2;
            } else if (Checkers.isReturn(strings[x]) || Checkers.isAssert(strings[x])) {
                if (Checkers.isAssert(strings[x])) {
                    myToken.setType(507);
                } else {
                    myToken.setType(500);
                }
                myToken.add(tokens[x]);
                newExpr = new StringBuffer();
                if (++x == tokens.length) {
                    parser.reportError("Missing terminator", new Token(newExpr.toString(), tokens[x - 1].getHint(), newExpr.toString().length()));
                    return null;
                }
                int hint = tokens[x].getHint();
                while (x < strings.length && !strings[x].equals("EOT")) {
                    newExpr.append(strings[x]);
                    newExpr.append(" ");
                    if (++x < tokens.length) continue;
                    parser.reportError("Missing terminator", new Token(newExpr.toString(), tokens[x - 1].getHint(), newExpr.toString().length()));
                    return null;
                }
                if (newExpr.length() > 0) {
                    myToken.add(new Token(newExpr.toString(), hint));
                }
            } else if (x + 1 < tokens.length && Checkers.isImportStatement(strings[x], strings[x + 1])) {
                myToken.setType(444);
                ++x;
                newExpr = new StringBuffer();
                while (x < strings.length && !strings[x].equals("EOT")) {
                    if (strings[x].equals("from:")) {
                        if (newExpr.length() == 0) {
                            parser.reportError("Attempted to import '' from:", new Token("import from:", tokens[x].getHint(), "import from:".length()));
                            return null;
                        }
                        myToken.add(new Token(newExpr.toString(), tokens[x].getHint()));
                        newExpr = new StringBuffer();
                    } else {
                        newExpr.append(strings[x]);
                    }
                    if (++x < tokens.length) continue;
                    parser.reportError("Missing terminator", new Token(newExpr.toString(), tokens[x - 1].getHint(), newExpr.toString().length()));
                    return null;
                }
                if (newExpr.length() > 0) {
                    myToken.add(new Token(newExpr.toString(), tokens[x].getHint()));
                }
            } else if (Checkers.isIndex(strings[x])) {
                myToken.setType(611);
                myToken.add(tokens[x]);
            } else if (!strings[x].equals("EOT")) {
                if (x + 2 < tokens.length && Checkers.isBindPredicate(strings[x], strings[x + 1], strings[x + 2])) {
                    myToken.setType(504);
                    myToken.add(tokens[x]);
                    myToken.add(tokens[x + 1]);
                    myToken.add(tokens[x + 2]);
                    x += 2;
                } else if (x + 2 < tokens.length && Checkers.isBind(strings[x], strings[x + 1], strings[x + 2])) {
                    myToken.setType(502);
                    myToken.add(tokens[x]);
                    myToken.add(tokens[x + 1]);
                    myToken.add(tokens[x + 2]);
                    x += 2;
                } else if (Checkers.isIncrementHack(strings[x])) {
                    myToken.setType(901);
                    myToken.add(tokens[x]);
                } else if (Checkers.isDecrementHack(strings[x])) {
                    myToken.setType(902);
                    myToken.add(tokens[x]);
                } else if (Checkers.isBlock(strings[x])) {
                    myToken.setType(150);
                    myToken.add(tokens[x]);
                } else if (Checkers.isBacktick(strings[x])) {
                    myToken.setType(506);
                    myToken.add(tokens[x]);
                } else if (Checkers.isFunctionCall(strings[x])) {
                    myToken.setType(604);
                    myToken.add(tokens[x]);
                } else if (x + 3 < tokens.length && Checkers.isBindFilter(strings[x], strings[x + 1], strings[x + 2], strings[x + 3])) {
                    myToken.setType(505);
                    myToken.add(tokens[x]);
                    myToken.add(tokens[x + 1]);
                    myToken.add(tokens[x + 2]);
                    myToken.add(tokens[x + 3]);
                    x += 3;
                } else {
                    int check = TokenParser.findPrecedentOperators(myToken, data, x, "+= -= *= .= /= %= |= &= ^=", 2);
                    if (check != x || (check = TokenParser.findPrecedentOperators(myToken, data, x, "<<= >>=", 3)) != x) {
                        if (Checkers.isExpression(strings[x])) {
                            myToken.setType(204);
                        } else {
                            myToken.setType(203);
                        }
                        x = check;
                    } else {
                        check = TokenParser.findPrecedentOperators(myToken, data, x, "=", 1);
                        if (check != x) {
                            if (Checkers.isExpression(strings[x])) {
                                myToken.setType(202);
                            } else {
                                myToken.setType(200);
                            }
                            x = check;
                        } else {
                            TokenList alist = new TokenList();
                            for (int z = x; z < tokens.length && !strings[z].equals("EOT") && strings[z].indexOf(10) == -1; ++z) {
                                alist.add(tokens[z]);
                            }
                            parser.reportError("Syntax error", new Token(alist.toString(), tokens[x].getHint()));
                            return null;
                        }
                    }
                }
            }
            if (myToken.getType() == 0) continue;
            value.add(myToken);
        }
        return value;
    }
}

