/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

public class Token {
    protected String term;
    protected int hint;
    protected int marker;
    protected int tophint;

    public Token(String term, int hint) {
        this(term, hint, -1);
    }

    public Token(String _term, int _hint, int _marker) {
        this.term = _term;
        this.hint = _hint;
        this.marker = _marker;
        this.tophint = -1;
    }

    public String toString() {
        return this.term;
    }

    public int getMarkerIndex() {
        return this.marker;
    }

    public Token copy(int _hint) {
        return new Token(this.term, _hint);
    }

    public Token copy(String text) {
        return new Token(text, this.getHint());
    }

    public String getMarker() {
        if (this.marker > -1) {
            StringBuffer temp = new StringBuffer();
            for (int x = 0; x < this.marker - 1; ++x) {
                temp.append(" ");
            }
            temp.append("^");
            return temp.toString();
        }
        return null;
    }

    public int getTopHint() {
        if (this.tophint >= 0) {
            return this.tophint;
        }
        this.tophint = this.hint;
        int endAt = -1;
        while ((endAt = this.term.indexOf(10, endAt + 1)) > -1) {
            ++this.tophint;
        }
        return this.tophint;
    }

    public int getHint() {
        return this.hint;
    }
}

