/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import java.util.LinkedList;
import sleep.parser.Token;

public class StringIterator {
    protected int position = 0;
    protected int lineNo;
    protected char[] text;
    protected String texts;
    protected int begin = 0;
    protected LinkedList mark1 = new LinkedList();
    protected LinkedList mark2 = new LinkedList();

    public StringIterator(String text) {
        this(text, 0);
    }

    public String toString() {
        return this.texts;
    }

    public StringIterator(String _text, int _lineNo) {
        this.texts = _text;
        this.text = _text.toCharArray();
        this.lineNo = _lineNo;
    }

    public boolean hasNext() {
        return this.position < this.text.length;
    }

    public boolean hasNext(int n) {
        return this.position + n - 1 < this.text.length;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public Token getErrorToken() {
        return new Token(this.getEntireLine(), this.getLineNumber(), this.getLineMarker());
    }

    public String getEntireLine() {
        int temp;
        for (temp = this.position; temp < this.text.length && this.text[temp] != '\n'; ++temp) {
        }
        return this.texts.substring(this.begin, temp);
    }

    public int getLineMarker() {
        return this.position - this.begin;
    }

    public boolean isNextString(String n) {
        return this.position + n.length() <= this.text.length && this.texts.substring(this.position, this.position + n.length()).equals(n);
    }

    public boolean isNextChar(char n) {
        return this.hasNext() && this.text[this.position] == n;
    }

    public char peek() {
        return this.hasNext() ? this.text[this.position] : (char)'\u0000';
    }

    public void skip(int n) {
        this.position += n;
    }

    public String next(int n) {
        StringBuffer buffer = new StringBuffer();
        for (int x = 0; x < n; ++x) {
            buffer.append(this.next());
        }
        return buffer.toString();
    }

    public char next() {
        char current = this.text[this.position];
        if (this.position > 0 && this.text[this.position - 1] == '\n') {
            ++this.lineNo;
            this.begin = this.position;
        }
        ++this.position;
        return current;
    }

    public void mark() {
        this.mark1.add(0, new Integer(this.position));
        this.mark2.add(0, new Integer(this.lineNo));
    }

    public String reset() {
        Integer temp1 = (Integer)this.mark1.removeFirst();
        Integer temp2 = (Integer)this.mark2.removeFirst();
        return this.texts.substring(temp1, this.position);
    }

    public static void main(String[] args) {
        StringIterator temp = new StringIterator(args[0]);
        StringBuffer blah = new StringBuffer();
        while (temp.hasNext()) {
            char t = temp.next();
            blah.append(t);
            if (t != '\n') continue;
            System.out.print(temp.getLineNumber() + ": " + blah.toString());
            blah = new StringBuffer();
        }
    }
}

