/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import java.util.LinkedList;
import sleep.error.SyntaxError;
import sleep.parser.Token;

public class Rule {
    public static int PRESERVE_ENTITY = 100;
    public static int PRESERVE_SINGLE = 101;
    int type;
    char left;
    char right;
    char single;
    String errorDescription1;
    String errorDescription2;
    protected LinkedList open = new LinkedList();
    protected LinkedList close = new LinkedList();

    public int getType() {
        return this.type;
    }

    public String toString() {
        return this.errorDescription1;
    }

    public SyntaxError getSyntaxError() {
        while (this.open.size() > 0 && this.close.size() > 0) {
            this.open.removeLast();
            this.close.removeLast();
        }
        String desc = this.type == PRESERVE_ENTITY && this.open.size() > 0 ? this.errorDescription2 : this.errorDescription1;
        Token token = this.open.size() > 0 ? (Token)this.open.getFirst() : (Token)this.close.getFirst();
        this.open.clear();
        this.close.clear();
        return new SyntaxError(desc, token.toString(), token.getHint(), token.getMarker());
    }

    public String wrap(String value) {
        StringBuffer rv = new StringBuffer(value.length() + 2);
        if (this.type == PRESERVE_ENTITY) {
            rv.append(this.left);
            rv.append(value);
            rv.append(this.right);
        } else {
            rv.append(this.single);
            rv.append(value);
            rv.append(this.single);
        }
        return rv.toString();
    }

    public boolean isLeft(char n) {
        return this.type == PRESERVE_ENTITY && this.left == n;
    }

    public boolean isRight(char n) {
        return this.type == PRESERVE_ENTITY && this.right == n;
    }

    public boolean isMatch(char n) {
        return this.type == PRESERVE_SINGLE && this.single == n;
    }

    public boolean isBalanced() {
        if (this.open.size() == this.close.size()) {
            this.open.clear();
            this.close.clear();
            return true;
        }
        return false;
    }

    public void witnessOpen(Token token) {
        this.open.add(token);
        this.adjustLists();
    }

    public void witnessClose(Token token) {
        if (this.type == PRESERVE_ENTITY) {
            this.close.addFirst(token);
        } else {
            this.close.add(token);
        }
        this.adjustLists();
    }

    private void adjustLists() {
        if (this.open.size() > 0 && this.close.size() > 0 && ((Token)this.open.getLast()).getHint() == ((Token)this.close.getLast()).getHint()) {
            this.open.removeLast();
            this.close.removeLast();
        }
    }

    public char getLeft() {
        return this.left;
    }

    public char getRight() {
        return this.right;
    }

    public Rule copyRule() {
        if (this.type == PRESERVE_ENTITY) {
            return new Rule(this.errorDescription1, this.errorDescription2, this.left, this.right);
        }
        return new Rule(this.errorDescription1, this.single);
    }

    public Rule(String errorDesc1, String errorDesc2, char l, char r) {
        this.type = PRESERVE_ENTITY;
        this.left = l;
        this.right = r;
        this.errorDescription1 = errorDesc1;
        this.errorDescription2 = errorDesc2;
    }

    public Rule(String errorDesc, char s) {
        this.type = PRESERVE_SINGLE;
        this.single = s;
        this.errorDescription1 = errorDesc;
    }

    public Rule() {
    }
}

