/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import sleep.engine.Block;
import sleep.engine.GeneratedSteps;
import sleep.error.SyntaxError;
import sleep.error.YourCodeSucksException;
import sleep.parser.CodeGenerator;
import sleep.parser.ImportManager;
import sleep.parser.LexicalAnalyzer;
import sleep.parser.Statement;
import sleep.parser.StringIterator;
import sleep.parser.Token;
import sleep.parser.TokenList;
import sleep.parser.TokenParser;

public class Parser {
    private static final boolean DEBUG_ITER = false;
    private static final boolean DEBUG_LEX = false;
    private static final boolean DEBUG_COMMENTS = false;
    private static final boolean DEBUG_TPARSER = false;
    protected String code;
    protected String name;
    protected LinkedList comments = new LinkedList();
    protected LinkedList errors = new LinkedList();
    protected LinkedList warnings = new LinkedList();
    protected TokenList tokens = new TokenList();
    protected LinkedList statements = new LinkedList();
    protected Block executeMe;
    public char EndOfTerm = (char)59;
    protected ImportManager imports;
    protected GeneratedSteps factory = null;

    public ImportManager getImportManager() {
        return this.imports;
    }

    public void setCodeFactory(GeneratedSteps s) {
        this.factory = s;
    }

    public void importPackage(String packagez, String from) {
        this.imports.importPackage(packagez, from);
    }

    public Class findImportedClass(String name) {
        return this.imports.findImportedClass(name);
    }

    public void setEndOfTerm(char c) {
        this.EndOfTerm = c;
    }

    public Parser(String _code) {
        this("unknown", _code);
    }

    public Parser(String _name, String _code) {
        this(_name, _code, null);
    }

    public Parser(String _name, String _code, ImportManager imps) {
        if (imps == null) {
            imps = new ImportManager();
        }
        this.imports = imps;
        this.importPackage("java.lang.*", null);
        this.importPackage("java.util.*", null);
        this.importPackage("sleep.runtime.*", null);
        this.code = _code;
        this.name = _name;
    }

    public void addStatement(Statement state) {
        this.statements.add(state);
    }

    public LinkedList getStatements() {
        return this.statements;
    }

    public String getName() {
        return this.name;
    }

    public void parse() throws YourCodeSucksException {
        this.parse(new StringIterator(this.code));
    }

    public void parse(StringIterator siter) throws YourCodeSucksException {
        TokenList tokens = LexicalAnalyzer.GroupBlockTokens(this, siter);
        if (this.hasErrors()) {
            this.errors.addAll(this.warnings);
            throw new YourCodeSucksException(this.errors);
        }
        LinkedList statements = TokenParser.ParseBlocks(this, tokens);
        if (this.hasErrors()) {
            this.errors.addAll(this.warnings);
            throw new YourCodeSucksException(this.errors);
        }
        CodeGenerator codegen = new CodeGenerator(this, this.factory);
        codegen.parseBlock(statements);
        if (this.hasErrors()) {
            this.errors.addAll(this.warnings);
            throw new YourCodeSucksException(this.errors);
        }
        this.executeMe = codegen.getRunnableBlock();
    }

    public void reportError(String description, Token responsible) {
        this.errors.add(new SyntaxError(description, responsible.toString(), responsible.getHint()));
    }

    public void reportErrorWithMarker(String description, Token responsible) {
        this.errors.add(new SyntaxError(description, responsible.toString(), responsible.getHint(), responsible.getMarker()));
    }

    public void reportError(SyntaxError error) {
        this.errors.add(error);
    }

    public Block getRunnableBlock() {
        return this.executeMe;
    }

    public void reportWarning(String description, Token responsible) {
        this.warnings.add(new SyntaxError(description, responsible.toString(), responsible.getHint()));
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public void addComment(String text) {
        this.comments.add(text);
    }

    public static void main(String[] args) {
        try {
            String text;
            File afile = new File(args[0]);
            BufferedReader temp = new BufferedReader(new InputStreamReader(new FileInputStream(afile)));
            StringBuffer data = new StringBuffer();
            while ((text = temp.readLine()) != null) {
                data.append(text);
                data.append('\n');
            }
            Parser p = new Parser(data.toString());
            p.parse();
            System.out.println(p.getRunnableBlock());
        }
        catch (YourCodeSucksException yex) {
            LinkedList errors = yex.getErrors();
            Iterator i = errors.iterator();
            while (i.hasNext()) {
                SyntaxError anError = (SyntaxError)i.next();
                System.out.println("Error: " + anError.getDescription() + " at line " + anError.getLineNumber());
                System.out.println("       " + anError.getCodeSnippet());
                if (anError.getMarker() == null) continue;
                System.out.println("       " + anError.getMarker());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

