/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import sleep.parser.Checkers;
import sleep.parser.CommentRule;
import sleep.parser.Parser;
import sleep.parser.ParserUtilities;
import sleep.parser.Rule;
import sleep.parser.StringIterator;
import sleep.parser.Token;
import sleep.parser.TokenList;

public class LexicalAnalyzer {
    protected static Rule PAREN_RULE;
    protected static Rule BLOCK_RULE;
    protected static Rule INDEX_RULE;
    protected static Rule DQUOTE_RULE;
    protected static Rule SQUOTE_RULE;
    protected static Rule BACKTICK_RULE;
    protected static Rule COMMENT_RULE;
    protected static char EndOfTerm;

    private static boolean isSkippable(Parser p, char f) {
        return LexicalAnalyzer.isWhite(f) || LexicalAnalyzer.isEndOfTerm(p, f) || LexicalAnalyzer.isEndOfLine(f);
    }

    private static boolean isWhite(char f) {
        return f == ' ' || f == '\t';
    }

    private static boolean isBuiltInOperator(char f, StringBuffer aTerm, StringIterator iter) {
        return f == '.' && (aTerm.length() <= 0 || !Character.isDigit(aTerm.charAt(aTerm.length() - 1)) || aTerm.charAt(0) == '$') && !iter.isNextChar('=');
    }

    private static boolean isEndOfTerm(Parser parser, char f) {
        return f == parser.EndOfTerm;
    }

    private static boolean isEndOfLine(char f) {
        return f == '\n' || f == '\r';
    }

    public static TokenList GroupBlockTokens(Parser parser, StringIterator i) {
        return LexicalAnalyzer.GroupTokens(parser, i, ';');
    }

    public static TokenList GroupExpressionIndexTokens(Parser parser, StringIterator i) {
        return LexicalAnalyzer.GroupTokens(parser, i, ':');
    }

    private static TokenList GroupTokens(Parser parser, StringIterator i, char Eot) {
        parser.setEndOfTerm(Eot);
        Token[] terms = LexicalAnalyzer.CreateTerms(parser, i).getTokens();
        TokenList value = new TokenList();
        StringBuffer rhs = new StringBuffer();
        int tok = 0;
        for (int x = 0; x < terms.length; ++x) {
            if (x + 1 < terms.length) {
                String a = terms[x].toString();
                String b = terms[x + 1].toString();
                tok = x;
                if (x + 2 < terms.length && Checkers.isClassLiteral(a) && b.equals(".")) {
                    rhs.append(terms[x]);
                    while (x + 2 < terms.length && terms[x + 1].toString().equals(".") && Checkers.isClassPiece(terms[x + 2].toString())) {
                        rhs.append(".");
                        rhs.append(terms[x + 2]);
                        x += 2;
                    }
                } else if (Checkers.isFunctionCall(a, b) || Checkers.isIndexableItem(a, b)) {
                    rhs.append(a.toString());
                    rhs.append(b.toString());
                    ++x;
                    while (x + 1 < terms.length && Checkers.isIndex(terms[x + 1].toString())) {
                        rhs.append(terms[x + 1].toString());
                        ++x;
                    }
                }
            }
            if (rhs.length() > 0) {
                value.add(ParserUtilities.makeToken(rhs.toString(), terms[tok]));
                rhs = new StringBuffer();
                continue;
            }
            if (!Checkers.isComment(terms[x].toString())) {
                value.add(terms[x]);
                continue;
            }
            parser.addComment(terms[x].toString());
        }
        return value;
    }

    public static TokenList GroupParameterTokens(Parser parser, StringIterator f) {
        return LexicalAnalyzer.GroupTokens(parser, f, ',');
    }

    public static TokenList CreateTerms(Parser parser, StringIterator f) {
        return LexicalAnalyzer.CreateTerms(parser, f, true, true);
    }

    public static TokenList CreateTerms(Parser parser, StringIterator f, boolean showEOT, boolean showEOL) {
        Rule[] temp = new Rule[]{PAREN_RULE.copyRule(), BLOCK_RULE.copyRule(), DQUOTE_RULE.copyRule(), SQUOTE_RULE.copyRule(), INDEX_RULE.copyRule(), BACKTICK_RULE.copyRule(), COMMENT_RULE};
        return LexicalAnalyzer.CreateTerms(parser, f, temp, showEOT, showEOL);
    }

    private static String AdvanceTerms(Parser report, StringIterator iterator, Rule term, Rule[] rules) {
        term.witnessOpen(new Token(iterator.getEntireLine(), iterator.getLineNumber(), iterator.getLineMarker()));
        StringBuffer value = new StringBuffer();
        int initialLine = iterator.getLineNumber();
        while (iterator.hasNext()) {
            char temp = iterator.next();
            if (temp == '\\' && term.getType() == Rule.PRESERVE_SINGLE && term != COMMENT_RULE) {
                if (!iterator.hasNext() && report != null) {
                    report.reportError("Escape is end of string", new Token(value.toString(), iterator.getLineNumber(), iterator.getLineMarker()));
                    continue;
                }
                value.append(temp);
                value.append(iterator.next());
                continue;
            }
            if (term.isRight(temp) || term.isMatch(temp)) {
                term.witnessClose(new Token(iterator.getEntireLine(), iterator.getLineNumber(), iterator.getLineMarker()));
                return value.toString();
            }
            if (term.getType() != Rule.PRESERVE_SINGLE && term != COMMENT_RULE) {
                boolean match = false;
                for (int x = 0; x < rules.length; ++x) {
                    if (rules[x].isLeft(temp) || rules[x].isMatch(temp)) {
                        String result = LexicalAnalyzer.AdvanceTerms(report, iterator, rules[x], rules);
                        if (result == null) {
                            return null;
                        }
                        value.append(rules[x].wrap(result));
                        match = true;
                        break;
                    }
                    if (!rules[x].isRight(temp) || rules[x] == term) continue;
                    rules[x].witnessClose(new Token(iterator.getEntireLine(), iterator.getLineNumber(), iterator.getLineMarker()));
                }
                if (match) continue;
                value.append(temp);
                continue;
            }
            value.append(temp);
        }
        return null;
    }

    public static TokenList CreateTerms(Parser parser, StringIterator iterator, Rule[] rules, boolean showEOT, boolean showEOL) {
        Token newTerm;
        TokenList terms = new TokenList();
        boolean match = false;
        StringBuffer aTerm = new StringBuffer();
        while (iterator.hasNext()) {
            match = false;
            char temp = iterator.next();
            for (int x = 0; x < rules.length; ++x) {
                if (rules[x].isLeft(temp) || rules[x].isMatch(temp)) {
                    if (aTerm.length() > 0) {
                        newTerm = new Token(LexicalAnalyzer.trim(parser, aTerm.toString()), iterator.getLineNumber());
                        terms.add(newTerm);
                        aTerm = new StringBuffer();
                    }
                    int curLine = iterator.getLineNumber();
                    String result = LexicalAnalyzer.AdvanceTerms(parser, iterator, rules[x], rules);
                    if (result == null) {
                        result = "";
                    }
                    newTerm = new Token(rules[x].wrap(result), curLine);
                    terms.add(newTerm);
                    match = true;
                    break;
                }
                if (!rules[x].isRight(temp)) continue;
                rules[x].witnessClose(new Token(iterator.getEntireLine(), iterator.getLineNumber()));
            }
            if (match) continue;
            if (LexicalAnalyzer.isEndOfTerm(parser, temp)) {
                if (aTerm.length() > 0) {
                    newTerm = new Token(LexicalAnalyzer.trim(parser, aTerm.toString()), iterator.getLineNumber());
                    terms.add(newTerm);
                    aTerm = new StringBuffer();
                }
                newTerm = new Token("EOT", iterator.getLineNumber());
                terms.add(newTerm);
                continue;
            }
            if (LexicalAnalyzer.isBuiltInOperator(temp, aTerm, iterator)) {
                if (aTerm.length() > 0) {
                    newTerm = new Token(LexicalAnalyzer.trim(parser, aTerm.toString()), iterator.getLineNumber());
                    terms.add(newTerm);
                    aTerm = new StringBuffer();
                }
                terms.add(new Token(temp + "", iterator.getLineNumber()));
                continue;
            }
            if (LexicalAnalyzer.isSkippable(parser, temp)) {
                if (aTerm.length() <= 0) continue;
                newTerm = aTerm.length() == 1 && aTerm.charAt(0) == '%' ? new Token("% ", iterator.getLineNumber()) : new Token(LexicalAnalyzer.trim(parser, aTerm.toString()), iterator.getLineNumber());
                terms.add(newTerm);
                aTerm = new StringBuffer();
                continue;
            }
            aTerm.append(temp);
        }
        if (aTerm.length() > 0) {
            newTerm = new Token(LexicalAnalyzer.trim(parser, aTerm.toString()), iterator.getLineNumber());
            terms.add(newTerm);
        }
        for (int x = 0; x < rules.length; ++x) {
            if (rules[x].isBalanced()) continue;
            parser.reportError(rules[x].getSyntaxError());
        }
        return terms;
    }

    public static String trim(Parser parser, String blah) {
        int y;
        int x;
        if (blah.length() == 0 || blah.equals(" ")) {
            return "";
        }
        for (x = 0; x < blah.length() && LexicalAnalyzer.isSkippable(parser, blah.charAt(x)); ++x) {
        }
        for (y = blah.length() - 1; y > 0 && LexicalAnalyzer.isSkippable(parser, blah.charAt(y)); --y) {
        }
        if (x > y) {
            return "";
        }
        return blah.substring(x, y + 1);
    }

    static {
        BLOCK_RULE = new Rule("Mismatched Braces - missing open brace", "Mismatched Braces - missing close brace", '{', '}');
        INDEX_RULE = new Rule("Mismatched Indices - missing open index", "Mismatched Indices - missing close index", '[', ']');
        DQUOTE_RULE = new Rule("Runaway string", '\"');
        SQUOTE_RULE = new Rule("Runaway string", '\'');
        BACKTICK_RULE = new Rule("Runaway string", '`');
        PAREN_RULE = new Rule("Mismatched Parentheses - missing open paren", "Mismatched Parentheses - missing close paren", '(', ')');
        COMMENT_RULE = new CommentRule();
        EndOfTerm = (char)59;
    }
}

