/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import sleep.parser.ParserConfig;

public class ImportManager {
    protected Map imports = new LinkedHashMap();
    protected HashMap classes = new HashMap();
    protected HashMap jars = new HashMap();

    public void importPackage(String packagez, String from) {
        Class found;
        String pack2;
        String clas;
        if (packagez.indexOf(".") > -1) {
            clas = packagez.substring(packagez.lastIndexOf(".") + 1, packagez.length());
            pack2 = packagez.substring(0, packagez.lastIndexOf("."));
        } else {
            clas = packagez;
            pack2 = null;
        }
        if (from != null) {
            File returnValue = null;
            returnValue = ParserConfig.findJarFile(from);
            if (returnValue == null || !returnValue.exists()) {
                throw new RuntimeException("jar file to import package from was not found!");
            }
            try {
                if (!this.jars.containsKey(from)) {
                    URLClassLoader loader = new URLClassLoader(new URL[]{returnValue.toURL()}, Thread.currentThread().getContextClassLoader());
                    this.jars.put(from, loader);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (clas.equals("*")) {
            this.imports.put(pack2, from);
        } else if (pack2 == null) {
            this.imports.put(packagez, from);
            found = this.resolveClass(null, packagez, (String)this.imports.get(packagez));
            this.classes.put(packagez, found);
            if (found == null) {
                throw new RuntimeException("imported class was not found");
            }
        } else {
            this.imports.put(packagez, from);
            found = this.findImportedClass(packagez);
            this.classes.put(clas, found);
            if (found == null) {
                throw new RuntimeException("imported class was not found");
            }
        }
    }

    private Class resolveClass(String pack2, String clas, String jar) {
        StringBuffer name = new StringBuffer();
        if (pack2 != null) {
            name.append(pack2);
            name.append(".");
        }
        name.append(clas);
        try {
            if (jar != null) {
                ClassLoader cl = (ClassLoader)this.jars.get(jar);
                return Class.forName(name.toString(), true, cl);
            }
            return Class.forName(name.toString());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Class findImportedClass(String name) {
        if (this.classes.get(name) == null) {
            Class rv = null;
            if (name.indexOf(".") > -1) {
                String clas = name.substring(name.lastIndexOf(".") + 1, name.length());
                String pack2 = name.substring(0, name.lastIndexOf("."));
                rv = this.resolveClass(pack2, clas, (String)this.imports.get(name));
            } else {
                rv = this.resolveClass(null, name, (String)this.imports.get(name));
                Iterator i = this.imports.entrySet().iterator();
                while (i.hasNext() && rv == null) {
                    Map.Entry en = i.next();
                    rv = this.resolveClass((String)en.getKey(), name, (String)en.getValue());
                }
            }
            this.classes.put(name, rv);
        }
        return (Class)this.classes.get(name);
    }
}

