/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import sleep.engine.Block;
import sleep.engine.GeneratedSteps;
import sleep.engine.Step;
import sleep.engine.atoms.Check;
import sleep.engine.atoms.PLiteral;
import sleep.parser.Checkers;
import sleep.parser.LexicalAnalyzer;
import sleep.parser.Parser;
import sleep.parser.ParserConstants;
import sleep.parser.ParserUtilities;
import sleep.parser.Statement;
import sleep.parser.StringIterator;
import sleep.parser.Token;
import sleep.parser.TokenList;
import sleep.parser.TokenParser;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class CodeGenerator
implements ParserConstants {
    protected Block CURRENT_BLOCK;
    protected Stack BACKUP_BLOCKS;
    protected GeneratedSteps factory;
    protected Parser parser;
    protected static HashMap escape_constants = new HashMap();

    public static void installEscapeConstant(char c, String value) {
        escape_constants.put(c + "", value);
    }

    public Block getRunnableBlock() {
        return this.CURRENT_BLOCK;
    }

    public void add(Step n, Token token) {
        this.CURRENT_BLOCK.add(n);
        n.setInfo(token.getHint());
    }

    public void backup() {
        this.BACKUP_BLOCKS.push(this.CURRENT_BLOCK);
        this.CURRENT_BLOCK = new Block(this.parser.getName());
    }

    public Block restore() {
        Block temp = this.CURRENT_BLOCK;
        this.CURRENT_BLOCK = (Block)this.BACKUP_BLOCKS.pop();
        return temp;
    }

    public CodeGenerator(Parser _parser, GeneratedSteps _factory) {
        this.parser = _parser;
        this.factory = _factory != null ? _factory : new GeneratedSteps();
        this.CURRENT_BLOCK = new Block(this.parser.getName());
        this.BACKUP_BLOCKS = new Stack();
    }

    public CodeGenerator(Parser _parser) {
        this(_parser, null);
    }

    public Check parsePredicate(Token data) {
        Statement allData = TokenParser.ParsePredicate(this.parser, LexicalAnalyzer.GroupBlockTokens(this.parser, new StringIterator(data.toString(), data.getHint())));
        return this.parsePredicate(allData);
    }

    public Check parsePredicate(Statement parsePred) {
        Token[] tokens = parsePred.getTokens();
        String[] strings = parsePred.getStrings();
        switch (parsePred.getType()) {
            case 805: {
                return this.parsePredicate(ParserUtilities.extract(tokens[0]));
            }
            case 806: {
                if (strings[0].charAt(0) == '!' && strings[0].length() > 1) {
                    return this.parsePredicate(tokens[0].copy("!-istrue (" + strings[0].substring(1, strings[0].length()) + ")"));
                }
                return this.parsePredicate(tokens[0].copy("-istrue (" + strings[0] + ")"));
            }
            case 801: {
                this.backup();
                this.parseIdea(tokens[0]);
                this.parseIdea(tokens[2]);
                Check tempc = this.factory.Check(strings[1], this.restore());
                tempc.setInfo(tokens[1].getHint());
                return tempc;
            }
            case 802: {
                this.backup();
                this.parseIdea(tokens[1]);
                Check tempc = this.factory.Check(strings[0], this.restore());
                tempc.setInfo(tokens[0].getHint());
                return tempc;
            }
            case 804: {
                Check tempc = null;
                Stack<Token> queue = new Stack<Token>();
                for (int x = 0; x < tokens.length; ++x) {
                    queue.push(tokens[x]);
                }
                while (!queue.isEmpty()) {
                    Token t = (Token)queue.pop();
                    if (t.toString().equals("&&")) continue;
                    Check oldtemp = tempc;
                    tempc = this.parsePredicate(t);
                    tempc.setChoices(oldtemp, null);
                }
                return tempc;
            }
            case 803: {
                Check tempc = null;
                Stack<Token> queue = new Stack<Token>();
                for (int x = 0; x < tokens.length; ++x) {
                    queue.push(tokens[x]);
                }
                while (!queue.isEmpty()) {
                    Token t = (Token)queue.pop();
                    if (t.toString().equals("||")) continue;
                    Check oldtemp = tempc;
                    tempc = this.parsePredicate(t);
                    tempc.setChoices(null, oldtemp);
                }
                return tempc;
            }
        }
        this.parser.reportError("Unknown predicate.", tokens[0].copy(parsePred.toString()));
        return null;
    }

    public void parseObject(Token data) {
        Statement stmt = TokenParser.ParseObject(this.parser, LexicalAnalyzer.GroupExpressionIndexTokens(this.parser, new StringIterator(data.toString(), data.getHint())));
        if (this.parser.hasErrors()) {
            return;
        }
        this.parseObject(stmt);
    }

    public void parseObject(Statement datum) {
        String[] strings = datum.getStrings();
        Token[] tokens = datum.getTokens();
        Class aClass = null;
        switch (datum.getType()) {
            case 441: {
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[0]);
                if (tokens.length > 1) {
                    this.parseParameters(tokens[1]);
                }
                if ((aClass = this.parser.findImportedClass(strings[0])) == null) {
                    this.parser.reportError("Class " + strings[0] + " was not found", tokens[0]);
                }
                atom = this.factory.ObjectNew(aClass);
                this.add(atom, tokens[0]);
                break;
            }
            case 446: {
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[0]);
                if (tokens.length > 1) {
                    this.parseParameters(tokens[1]);
                }
                this.parseIdea(tokens[0]);
                atom = this.factory.ObjectAccess(null);
                this.add(atom, tokens[0]);
                break;
            }
            case 442: {
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[0]);
                if (tokens.length > 2) {
                    this.parseParameters(tokens[2]);
                }
                this.parseIdea(tokens[0]);
                atom = this.factory.ObjectAccess(strings[1]);
                this.add(atom, tokens[0]);
                break;
            }
            case 443: {
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[0]);
                if (tokens.length > 2) {
                    this.parseParameters(tokens[2]);
                }
                if ((aClass = this.parser.findImportedClass(strings[0])) == null) {
                    this.parser.reportError("Class " + strings[0] + " was not found", tokens[0]);
                }
                atom = this.factory.ObjectAccessStatic(aClass, strings[1]);
                this.add(atom, tokens[0]);
            }
        }
    }

    public void parseBlock(Token data) {
        LinkedList allData = TokenParser.ParseBlocks(this.parser, LexicalAnalyzer.GroupBlockTokens(this.parser, new StringIterator(data.toString(), data.getHint())));
        if (this.parser.hasErrors()) {
            return;
        }
        if (allData.size() == 0) {
            Step temp = new Step();
            this.add(temp, data);
        } else {
            this.parseBlock(allData);
        }
    }

    public void parseBlock(LinkedList data) {
        Iterator i = data.iterator();
        while (i.hasNext()) {
            this.parse((Statement)i.next());
        }
    }

    public List parseIdea(Token data) {
        LinkedList allData = TokenParser.ParseIdea(this.parser, LexicalAnalyzer.GroupBlockTokens(this.parser, new StringIterator(data.toString(), data.getHint())));
        if (this.parser.hasErrors()) {
            return null;
        }
        Iterator i = allData.iterator();
        while (i.hasNext()) {
            this.parse((Statement)i.next());
        }
        return allData;
    }

    public void parse(Statement datum) {
        String[] strings = datum.getStrings();
        Token[] tokens = datum.getTokens();
        switch (datum.getType()) {
            case 705: {
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[0]);
                atom = this.factory.Get(strings[0].substring(1));
                this.add(atom, tokens[0]);
                Scalar ascalar = SleepUtils.getScalar(strings[0].substring(1));
                atom = this.factory.SValue(ascalar);
                this.add(atom, tokens[0]);
                atom = this.factory.Operate("=>");
                this.add(atom, tokens[0]);
                break;
            }
            case 612: {
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[2]);
                List valuez = this.parseIdea(tokens[2]);
                Iterator iz = valuez.iterator();
                while (iz.hasNext()) {
                    Statement t = (Statement)iz.next();
                    if (t.getType() != 612) continue;
                    this.parser.reportError("key/value pair specified for '" + tokens[0] + "', did you forget a comma?", tokens[2]);
                }
                Scalar ascalar = SleepUtils.getScalar(strings[0]);
                atom = this.factory.SValue(ascalar);
                this.add(atom, tokens[0]);
                atom = this.factory.Operate(strings[1]);
                this.add(atom, tokens[1]);
                break;
            }
            case 603: {
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[2]);
                this.parseIdea(tokens[2]);
                this.parseIdea(tokens[0]);
                atom = this.factory.Operate(strings[1]);
                this.add(atom, tokens[1]);
                break;
            }
            case 611: {
                this.parseObject(ParserUtilities.extract(tokens[0]));
                break;
            }
            case 606: {
                StringBuffer sb = new StringBuffer(ParserUtilities.extract(strings[0]));
                for (int x = 0; x < sb.length(); ++x) {
                    char tempc;
                    if (sb.charAt(x) != '\\' || x + 1 >= sb.length() || (tempc = sb.charAt(x + 1)) != '\'' && tempc != '\\') continue;
                    sb.deleteCharAt(x);
                }
                Scalar ascalar = SleepUtils.getScalar(sb.toString());
                Step atom = this.factory.SValue(ascalar);
                this.add(atom, tokens[0]);
                break;
            }
            case 607: {
                Scalar ascalar = strings[0].endsWith("L") ? SleepUtils.getScalar(Long.decode(strings[0].substring(0, strings[0].length() - 1))) : SleepUtils.getScalar(Integer.decode(strings[0]));
                Step atom = this.factory.SValue(ascalar);
                this.add(atom, tokens[0]);
                break;
            }
            case 608: {
                Scalar ascalar = SleepUtils.getScalar(Double.parseDouble(strings[0]));
                Step atom = this.factory.SValue(ascalar);
                this.add(atom, tokens[0]);
                break;
            }
            case 609: {
                Scalar ascalar = SleepUtils.getScalar(Boolean.valueOf(strings[0]));
                Step atom = this.factory.SValue(ascalar);
                this.add(atom, tokens[0]);
                break;
            }
            case 614: {
                Class claz = this.parser.findImportedClass(strings[0].substring(1));
                if (claz == null) {
                    this.parser.reportError("unable to resolve class: " + strings[0].substring(1), tokens[0]);
                    break;
                }
                Scalar ascalar = SleepUtils.getScalar(this.parser.findImportedClass(strings[0].substring(1)));
                Step atom = this.factory.SValue(ascalar);
                this.add(atom, tokens[0]);
                break;
            }
            case 701: {
                if (strings[0].equals("$null")) {
                    Scalar ascalar = SleepUtils.getEmptyScalar();
                    Step atom = this.factory.SValue(ascalar);
                    this.add(atom, tokens[0]);
                    break;
                }
                Step atom = this.factory.Get(strings[0]);
                this.add(atom, tokens[0]);
                break;
            }
            case 710: {
                this.parseIdea(tokens[0]);
                for (int z = 1; z < tokens.length; ++z) {
                    this.backup();
                    Step atom = this.factory.CreateFrame();
                    this.add(atom, tokens[0]);
                    this.parseIdea(ParserUtilities.extract(tokens[z]));
                    atom = this.factory.Index(strings[0], this.restore());
                    this.add(atom, tokens[0]);
                }
                break;
            }
            case 601: {
                this.parseIdea(ParserUtilities.extract(tokens[0]));
                break;
            }
            case 506: {
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[0]);
                datum.setType(605);
                this.parse(datum);
                atom = this.factory.Call("__EXEC__");
                this.add(atom, tokens[0]);
                break;
            }
            case 605: {
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[0]);
                boolean isVar = false;
                StringBuffer d = new StringBuffer();
                LinkedList<PLiteral.Fragment> ll = new LinkedList<PLiteral.Fragment>();
                StringIterator si = new StringIterator(ParserUtilities.extract(strings[0]), tokens[0].getHint());
                while (si.hasNext()) {
                    char current = si.next();
                    if (current == '\\' && si.hasNext()) {
                        current = si.next();
                        String mutilate = current + "";
                        if (escape_constants.containsKey(mutilate)) {
                            d.append(escape_constants.get(mutilate));
                        } else if (current == 'u') {
                            if (!si.hasNext(4)) {
                                this.parser.reportErrorWithMarker("not enough remaining characters for \\uXXXX", si.getErrorToken());
                            } else {
                                mutilate = si.next(4);
                                try {
                                    int codepoint = Integer.parseInt(mutilate, 16);
                                    d.append((char)codepoint);
                                }
                                catch (NumberFormatException nex) {
                                    this.parser.reportErrorWithMarker("invalid unicode escape \\u" + mutilate + " - must be hex digits", si.getErrorToken());
                                }
                            }
                        } else if (current == 'x') {
                            if (!si.hasNext(2)) {
                                this.parser.reportErrorWithMarker("not enough remaining characters for \\xXX", si.getErrorToken());
                            } else {
                                mutilate = si.next(2);
                                try {
                                    int codepoint = Integer.parseInt(mutilate, 16);
                                    d.append((char)codepoint);
                                }
                                catch (NumberFormatException nex) {
                                    this.parser.reportErrorWithMarker("invalid unicode escape \\x" + mutilate + " - must be hex digits", si.getErrorToken());
                                }
                            }
                        } else {
                            d.append(current);
                        }
                    } else if (current == ' ' && si.isNextString("$+ ")) {
                        si.skip(3);
                    } else if (current == '$' && si.isNextChar('+')) {
                        this.parser.reportErrorWithMarker("operator $+ must be surrounded with whitespace", si.getErrorToken());
                    } else if (isVar && (Checkers.isEndOfVar(si.peek()) || !si.hasNext())) {
                        String varname;
                        d.append(current);
                        String[] ops = LexicalAnalyzer.CreateTerms(this.parser, new StringIterator(d.toString(), si.getLineNumber())).getStrings();
                        if (ops.length == 3) {
                            varname = ops[0] + ops[2];
                            String align = ParserUtilities.extract(ops[1]);
                            if (align.length() > 0) {
                                this.parseIdea(new Token(align, si.getLineNumber()));
                                ll.add(PLiteral.fragment(2, null));
                            } else {
                                this.parser.reportErrorWithMarker("Empty alignment specification for " + varname, si.getErrorToken());
                            }
                        } else {
                            varname = d.toString();
                        }
                        this.parseIdea(new Token(varname, si.getLineNumber()));
                        ll.add(PLiteral.fragment(3, null));
                        isVar = false;
                        d = new StringBuffer();
                    } else if (current == '$' && !Checkers.isEndOfVar(si.peek()) && si.hasNext()) {
                        ll.add(PLiteral.fragment(1, d.toString()));
                        d = new StringBuffer();
                        d.append('$');
                        isVar = true;
                        if (si.isNextChar('[')) {
                            int count = 0;
                            do {
                                if ((current = si.next()) == '[') {
                                    ++count;
                                }
                                if (current == ']') {
                                    --count;
                                }
                                d.append(current);
                            } while (si.hasNext() && count > 0);
                            if (count != 0) {
                                this.parser.reportError("missing close brace for variable alignment", new Token(d.toString(), si.getLineNumber()));
                                isVar = false;
                            } else if (!si.hasNext() || Checkers.isEndOfVar(si.peek())) {
                                this.parser.reportErrorWithMarker("can not align an empty variable", si.getErrorToken());
                                isVar = false;
                            }
                        }
                    } else {
                        d.append(current);
                    }
                    if (si.hasNext() || d.length() <= 0) continue;
                    ll.add(PLiteral.fragment(1, d.toString()));
                }
                atom = this.factory.PLiteral(ll);
                this.add(atom, tokens[0]);
                break;
            }
            case 901: {
                String mutilate = strings[0].substring(0, strings[0].length() - 2);
                this.parseBlock(new Token(mutilate + " = " + mutilate + " + 1;", tokens[0].getHint()));
                break;
            }
            case 902: {
                String mutilate = strings[0].substring(0, strings[0].length() - 2);
                this.parseBlock(new Token(mutilate + " = " + mutilate + " - 1;", tokens[0].getHint()));
                break;
            }
            case 504: {
                this.backup();
                this.parseBlock(tokens[2]);
                Step atom = this.factory.BindPredicate(strings[0], this.parsePredicate(ParserUtilities.extract(tokens[1])), this.restore());
                this.add(atom, tokens[0]);
                break;
            }
            case 505: {
                this.backup();
                this.parseBlock(tokens[3]);
                Block b = this.restore();
                Step atom = this.factory.BindFilter(strings[0], strings[1], b, strings[2]);
                this.add(atom, tokens[0]);
                break;
            }
            case 502: {
                this.backup();
                if (Checkers.isString(strings[1]) || Checkers.isLiteral(strings[1])) {
                    this.parseIdea(tokens[1]);
                } else {
                    this.parseIdea(new Token("'" + strings[1] + "'", tokens[1].getHint()));
                }
                Block nameBlock = this.restore();
                this.backup();
                this.parseBlock(tokens[2]);
                Step atom = this.factory.Bind(strings[0], nameBlock, this.restore());
                this.add(atom, tokens[0]);
                break;
            }
            case 403: {
                this.backup();
                this.parseBlock(ParserUtilities.extract(tokens[1]));
                Step atom = this.factory.PopTry();
                this.add(atom, tokens[4]);
                Block a = this.restore();
                this.backup();
                atom = this.factory.PopTry();
                this.add(atom, tokens[4]);
                this.parseBlock(ParserUtilities.extract(tokens[4]));
                Block b = this.restore();
                atom = this.factory.Try(a, b, strings[3]);
                this.add(atom, tokens[0]);
                break;
            }
            case 150: {
                this.parseBlock(ParserUtilities.extract(tokens[0]));
                break;
            }
            case 613: {
                this.backup();
                this.parseBlock(ParserUtilities.extract(tokens[0]));
                Step atom = this.factory.CreateClosure(this.restore());
                this.add(atom, tokens[0]);
                break;
            }
            case 604: {
                TokenList funcParms = LexicalAnalyzer.CreateTerms(this.parser, new StringIterator(strings[0], tokens[0].getHint()));
                strings = funcParms.getStrings();
                tokens = funcParms.getTokens();
                if (strings[0].charAt(0) != '&') {
                    strings[0] = '&' + strings[0];
                }
                if ((strings[0].equals("&iff") || strings[0].equals("&?")) && tokens.length > 1) {
                    TokenList terms = ParserUtilities.groupByParameterTerm(this.parser, ParserUtilities.extract(tokens[1]));
                    Token[] termsAr = terms.getTokens();
                    this.backup();
                    if (termsAr.length >= 2) {
                        this.parseIdea(termsAr[1]);
                    } else {
                        this.parseIdea(termsAr[0].copy("true"));
                    }
                    Block a = this.restore();
                    this.backup();
                    if (termsAr.length == 3) {
                        this.parseIdea(termsAr[2]);
                    } else {
                        this.parseIdea(termsAr[0].copy("false"));
                    }
                    Block b = this.restore();
                    Step atom = this.factory.Decide(this.parsePredicate(termsAr[0]), a, b);
                    this.add(atom, tokens[0]);
                    break;
                }
                if (tokens.length > 1) {
                    Step atom = this.factory.CreateFrame();
                    this.add(atom, tokens[0]);
                    if (strings[0].equals("&warn")) {
                        atom = this.factory.SValue(SleepUtils.getScalar(tokens[0].getHint()));
                        this.add(atom, tokens[0]);
                    }
                    this.parseParameters(ParserUtilities.extract(tokens[1]));
                    atom = this.factory.Call(strings[0]);
                    this.add(atom, tokens[0]);
                    break;
                }
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[0]);
                atom = this.factory.SValue(SleepUtils.getScalar(strings[0]));
                this.add(atom, tokens[0]);
                atom = this.factory.Call("function");
                this.add(atom, tokens[0]);
                break;
            }
            case 100: {
                this.backup();
                this.parseBlock(tokens[2]);
                Step atom = this.factory.Goto(this.parsePredicate(ParserUtilities.extract(tokens[1])), this.restore(), null);
                this.add(atom, tokens[1]);
                break;
            }
            case 101: {
                this.backup();
                this.parseBlock(tokens[3]);
                Block b = this.restore();
                this.backup();
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[2]);
                this.parseIdea(tokens[2]);
                this.backup();
                this.parseIdea(tokens[1]);
                atom = this.factory.Assign(this.restore());
                this.add(atom, tokens[2]);
                this.add(this.factory.SValue(SleepUtils.getEmptyScalar()), tokens[2]);
                Block a = this.restore();
                Check tempp = this.factory.Check("!is", a);
                tempp.setInfo(tokens[1].getHint());
                atom = this.factory.Goto(tempp, b, null);
                this.add(atom, tokens[1]);
                break;
            }
            case 202: 
            case 204: {
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[0]);
                TokenList terms2 = ParserUtilities.groupByParameterTerm(this.parser, ParserUtilities.extract(tokens[0]));
                Token[] termsAr2 = terms2.getTokens();
                for (int x = 0; x < termsAr2.length; ++x) {
                    this.parseIdea(termsAr2[x]);
                }
                this.parseIdea(tokens[2]);
                atom = datum.getType() == 204 ? this.factory.AssignTupleAndOperate(strings[1].substring(0, strings[1].length() - 1)) : this.factory.AssignT();
                this.add(atom, tokens[0]);
                break;
            }
            case 200: 
            case 203: {
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[2]);
                this.parseIdea(tokens[2]);
                this.backup();
                this.parseIdea(tokens[0]);
                atom = datum.getType() == 203 ? this.factory.AssignAndOperate(this.restore(), strings[1].substring(0, strings[1].length() - 1)) : this.factory.Assign(this.restore());
                this.add(atom, tokens[2]);
                break;
            }
            case 301: {
                this.backup();
                this.parseBlock(tokens[2]);
                Block a = this.restore();
                this.backup();
                if (tokens.length >= 4) {
                    if (strings[4].equals("if")) {
                        this.parseBlock(ParserUtilities.join(ParserUtilities.get(tokens, 4, tokens.length)));
                    } else {
                        this.parseBlock(tokens[4]);
                    }
                }
                Block b = this.restore();
                Step atom = this.factory.Decide(this.parsePredicate(ParserUtilities.extract(tokens[1])), a, b);
                this.add(atom, tokens[1]);
                break;
            }
            case 400: 
            case 402: {
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[0]);
                if (datum.getType() == 400) {
                    this.parseIdea(ParserUtilities.extract(tokens[2]));
                    atom = this.factory.IteratorCreate(null, strings[1]);
                } else {
                    this.parseIdea(ParserUtilities.extract(tokens[4]));
                    atom = this.factory.IteratorCreate(strings[1], strings[3]);
                }
                this.add(atom, tokens[0]);
                this.backup();
                if (datum.getType() == 400) {
                    this.parseBlock(ParserUtilities.extract(tokens[3]));
                } else {
                    this.parseBlock(ParserUtilities.extract(tokens[5]));
                }
                Block a = this.restore();
                this.backup();
                atom = this.factory.IteratorNext();
                this.add(atom, tokens[0]);
                Check tempp = this.factory.Check("-istrue", this.restore());
                tempp.setInfo(tokens[0].getHint());
                atom = this.factory.Goto(tempp, a, null);
                this.add(atom, tokens[1]);
                atom = this.factory.IteratorDestroy();
                this.add(atom, tokens[1]);
                break;
            }
            case 401: {
                Block a;
                Token[] extracted_terms = ParserUtilities.groupByBlockTerm(this.parser, ParserUtilities.extract(tokens[1])).getTokens();
                StringBuffer doThis = new StringBuffer();
                TokenList initial_terms = ParserUtilities.groupByParameterTerm(this.parser, extracted_terms[0]);
                Iterator i = initial_terms.getList().iterator();
                while (i.hasNext()) {
                    doThis.append(i.next().toString());
                    doThis.append("; ");
                }
                this.parseBlock(tokens[0].copy(doThis.toString()));
                if (extracted_terms.length == 3) {
                    this.backup();
                    doThis = new StringBuffer();
                    TokenList final_terms = ParserUtilities.groupByParameterTerm(this.parser, extracted_terms[2]);
                    i = final_terms.getList().iterator();
                    while (i.hasNext()) {
                        doThis.append(i.next().toString());
                        doThis.append("; ");
                    }
                    this.parseBlock(tokens[0].copy(doThis.toString()));
                    a = this.restore();
                } else {
                    a = null;
                    doThis = new StringBuffer();
                }
                this.backup();
                this.parseBlock(tokens[2]);
                this.parseBlock(tokens[0].copy(doThis.toString()));
                Block b = this.restore();
                Step atom = this.factory.Goto(this.parsePredicate(extracted_terms[1]), b, a);
                this.add(atom, tokens[1]);
                break;
            }
            case 444: {
                try {
                    if (strings.length == 1) {
                        this.parser.importPackage(strings[0], null);
                        break;
                    }
                    if (Checkers.isString(strings[1]) || Checkers.isLiteral(strings[1])) {
                        strings[1] = ParserUtilities.extract(strings[1]);
                    }
                    this.parser.importPackage(strings[0], strings[1]);
                }
                catch (Exception ex) {
                    if (tokens.length == 2) {
                        this.parser.reportError(ex.getMessage(), ParserUtilities.makeToken("import " + strings[0] + " from: " + strings[1], tokens[1]));
                        break;
                    }
                    this.parser.reportError(ex.getMessage(), ParserUtilities.makeToken("import " + strings[0], tokens[0]));
                }
                break;
            }
            case 507: {
                if (tokens.length == 1) {
                    this.parser.reportError("Assertion can't be empty!", tokens[0]);
                    return;
                }
                if (Boolean.valueOf(System.getProperty("sleep.assert", "true")) == Boolean.FALSE) {
                    return;
                }
                Token[] assert_terms = ParserUtilities.groupByMessageTerm(this.parser, tokens[1]).getTokens();
                this.backup();
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[0]);
                if (assert_terms.length == 1) {
                    Scalar ascalar = SleepUtils.getScalar("assertion failed");
                    atom = this.factory.SValue(ascalar);
                    this.add(atom, tokens[0]);
                } else {
                    this.parseIdea(assert_terms[1]);
                }
                atom = this.factory.Call("&exit");
                this.add(atom, tokens[0]);
                Block b = this.restore();
                atom = this.factory.Decide(this.parsePredicate(assert_terms[0]), null, b);
                this.add(atom, tokens[1]);
                break;
            }
            case 500: {
                Step atom = this.factory.CreateFrame();
                this.add(atom, tokens[0]);
                if (strings[0].equals("done")) {
                    this.parseIdea(tokens[0].copy("1"));
                } else if (strings[0].equals("halt")) {
                    this.parseIdea(tokens[0].copy("2"));
                } else if (tokens.length >= 2) {
                    this.parseIdea(tokens[1]);
                } else {
                    this.parseIdea(tokens[0].copy("$null"));
                }
                if (strings[0].equals("break")) {
                    atom = this.factory.Return(2);
                    this.add(atom, tokens[0]);
                    break;
                }
                if (strings[0].equals("continue")) {
                    atom = this.factory.Return(4);
                    this.add(atom, tokens[0]);
                    break;
                }
                if (strings[0].equals("throw")) {
                    atom = this.factory.Return(16);
                    this.add(atom, tokens[0]);
                    break;
                }
                if (strings[0].equals("yield")) {
                    atom = this.factory.Return(8);
                    this.add(atom, tokens[0]);
                    break;
                }
                if (strings[0].equals("callcc")) {
                    atom = this.factory.Return(72);
                    this.add(atom, tokens[0]);
                    break;
                }
                atom = this.factory.Return(1);
                this.add(atom, tokens[0]);
                break;
            }
        }
    }

    public void parseParameters(Token token) {
        TokenList terms = ParserUtilities.groupByParameterTerm(this.parser, token);
        Token[] termsAr = terms.getTokens();
        for (int x = termsAr.length - 1; x >= 0; --x) {
            this.parseIdea(termsAr[x]);
        }
    }

    static {
        CodeGenerator.installEscapeConstant('t', "\t");
        CodeGenerator.installEscapeConstant('n', "\n");
        CodeGenerator.installEscapeConstant('r', "\r");
    }
}

