/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import java.util.Hashtable;
import sleep.parser.Parser;

public class Checkers {
    protected static Hashtable keywords = new Hashtable();

    public static void addKeyword(String keyword) {
        keywords.put(keyword, Boolean.TRUE);
    }

    public static boolean isIfStatement(String a, String b, String c) {
        return a.toString().equals("if") && Checkers.isExpression(b.toString()) && Checkers.isBlock(c.toString());
    }

    public static boolean isElseStatement(String a, String b) {
        return a.equals("else") && Checkers.isBlock(b);
    }

    public static boolean isElseIfStatement(String a, String b, String c, String d) {
        return a.equals("else") && Checkers.isIfStatement(b, c, d);
    }

    public static final boolean isIncrementHack(String a) {
        return Checkers.isScalar(a) && a.length() > 3 && a.substring(a.length() - 2, a.length()).equals("++");
    }

    public static final boolean isDecrementHack(String a) {
        return Checkers.isScalar(a) && a.length() > 3 && a.substring(a.length() - 2, a.length()).equals("--");
    }

    public static final boolean isObjectNew(String a, String b) {
        return a.equals("new");
    }

    public static final boolean isClosureCall(String a, String b) {
        return b.equals("EOT");
    }

    public static final boolean isImportStatement(String a, String b) {
        return a.equals("import");
    }

    public static final boolean isClassLiteral(String a) {
        return a.length() >= 2 && a.charAt(0) == '^';
    }

    public static final boolean isClassPiece(String a) {
        if (a.length() >= 1 && !Checkers.isVariable(a) && Character.isJavaIdentifierStart(a.charAt(0))) {
            for (int x = 1; x < a.length(); ++x) {
                if (Character.isJavaIdentifierPart(a.charAt(x)) || a.charAt(x) == '.') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final boolean isClassIdentifier(Parser parser, String a) {
        return Checkers.isClassPiece(a) && parser.findImportedClass(a) != null;
    }

    public static final boolean isBindFilter(String a, String b, String c, String d) {
        return Checkers.isBlock(d);
    }

    public static final boolean isBindPredicate(String a, String b, String c) {
        return Checkers.isExpression(b) && Checkers.isBlock(c);
    }

    public static final boolean isBind(String a, String b, String c) {
        return !b.equals("=") && Checkers.isBlock(c);
    }

    public static boolean isHash(String a) {
        return a.charAt(0) == '%';
    }

    public static boolean isArray(String a) {
        return a.charAt(0) == '@';
    }

    public static boolean isFunctionReferenceToken(String a) {
        return a.charAt(0) == '&' && a.length() > 1 && !a.equals("&&");
    }

    public static final boolean isVariableReference(String temp) {
        return temp.length() >= 3 && temp.charAt(0) == '\\' && !temp.equals("\\$null") && Checkers.isVariable(temp.substring(1));
    }

    public static final boolean isVariable(String temp) {
        return Checkers.isScalar(temp) || Checkers.isHash(temp) || Checkers.isArray(temp);
    }

    public static final boolean isScalar(String temp) {
        return temp.charAt(0) == '$';
    }

    public static boolean isIndex(String a) {
        return a.charAt(0) == '[' && a.charAt(a.length() - 1) == ']';
    }

    public static boolean isExpression(String a) {
        return a.charAt(0) == '(' && a.charAt(a.length() - 1) == ')';
    }

    public static boolean isBlock(String a) {
        return a.charAt(0) == '{' && a.charAt(a.length() - 1) == '}';
    }

    public static boolean isFunctionCall(String a, String b) {
        return (Checkers.isFunction(a) || a.equals("@") || a.equals("%")) && Checkers.isExpression(b);
    }

    public static boolean isFunction(String a) {
        return (Character.isJavaIdentifierStart(a.charAt(0)) || a.charAt(0) == '&') && a.charAt(0) != '$' && keywords.get(a) == null;
    }

    public static boolean isDataLiteral(String a) {
        return a.length() > 2 && (a.substring(0, 2).equals("@(") || a.substring(0, 2).equals("%("));
    }

    public static boolean isFunctionCall(String a) {
        return (Checkers.isFunction(a) || Checkers.isDataLiteral(a)) && a.indexOf(40) > -1 && a.indexOf(41) > -1;
    }

    public static boolean isIndexableItem(String a, String b) {
        return Checkers.isIndex(b) && (Checkers.isFunctionCall(a) || Checkers.isExpression(a) || Checkers.isVariable(a) || Checkers.isIndex(a) || Checkers.isFunctionReferenceToken(a) || Checkers.isBacktick(a));
    }

    public static boolean isIndexableItem(String a) {
        int idx;
        if (a.charAt(a.length() - 1) == ']' && (idx = a.lastIndexOf(91)) > 0) {
            return Checkers.isIndexableItem(a.substring(0, idx), a.substring(idx, a.length()));
        }
        return false;
    }

    public static boolean isHashIndex(String a) {
        return Checkers.isHash(a) && a.indexOf(91) > -1 && a.indexOf(93) > -1;
    }

    public static boolean isArrayIndex(String a) {
        return Checkers.isArray(a) && a.indexOf(91) > -1 && a.indexOf(93) > -1;
    }

    public static boolean isOperator(String a, String b, String c) {
        return true;
    }

    public static final boolean isSpecialWhile(String a, String b, String c, String d) {
        return Checkers.isWhile(a, c, d) && Checkers.isVariable(b);
    }

    public static final boolean isWhile(String a, String b, String c) {
        return a.equals("while") && Checkers.isExpression(b) && Checkers.isBlock(c);
    }

    public static final boolean isFor(String a, String b, String c) {
        return a.equals("for") && Checkers.isExpression(b) && Checkers.isBlock(c);
    }

    public static final boolean isTryCatch(String a, String b, String c, String d, String e) {
        return a.equals("try") && c.equals("catch") && Checkers.isBlock(b) && Checkers.isBlock(e) && Checkers.isScalar(d);
    }

    public static final boolean isForeach(String a, String b, String c, String d) {
        return a.equals("foreach") && Checkers.isVariable(b) && Checkers.isExpression(c) && Checkers.isBlock(d);
    }

    public static final boolean isSpecialForeach(String a, String b, String c, String d, String e, String f) {
        return a.equals("foreach") && Checkers.isVariable(b) && c.equals("=>") && Checkers.isVariable(d) && Checkers.isExpression(e) && Checkers.isBlock(f);
    }

    public static final boolean isAssert(String temp) {
        return temp.equals("assert");
    }

    public static final boolean isReturn(String temp) {
        return temp.equals("return") || temp.equals("done") || temp.equals("halt") || temp.equals("break") || temp.equals("yield") || temp.equals("continue") || temp.equals("throw") || temp.equals("callcc");
    }

    public static final boolean isString(String item) {
        return item.charAt(0) == '\"' && item.charAt(item.length() - 1) == '\"';
    }

    public static final boolean isBacktick(String item) {
        return item.charAt(0) == '`' && item.charAt(item.length() - 1) == '`';
    }

    public static final boolean isLiteral(String item) {
        return item.charAt(0) == '\'' && item.charAt(item.length() - 1) == '\'';
    }

    public static final boolean isNumber(String temp) {
        try {
            if (temp.endsWith("L")) {
                temp = temp.substring(0, temp.length() - 1);
                Long.decode(temp);
            } else {
                Integer.decode(temp);
            }
        }
        catch (Exception hex) {
            return false;
        }
        return true;
    }

    public static final boolean isDouble(String temp) {
        try {
            Double.parseDouble(temp);
        }
        catch (Exception hex) {
            return false;
        }
        return true;
    }

    public static final boolean isBoolean(String temp) {
        return temp.equals("true") || temp.equals("false");
    }

    public static final boolean isBiPredicate(String a, String b, String c) {
        return true;
    }

    public static final boolean isUniPredicate(String a, String b) {
        return a.charAt(0) == '-' || a.length() > 1 && a.charAt(0) == '!' && a.charAt(1) == '-';
    }

    public static final boolean isAndPredicate(String a, String b, String c) {
        return b.equals("&&");
    }

    public static final boolean isOrPredicate(String a, String b, String c) {
        return b.equals("||");
    }

    public static final boolean isComment(String a) {
        return a.charAt(0) == '#' && a.charAt(a.length() - 1) == '\n';
    }

    public static final boolean isEndOfVar(char n) {
        return n == ' ' || n == '\t' || n == '\n' || n == '$' || n == '\\';
    }

    static {
        keywords.put("if", Boolean.TRUE);
        keywords.put("for", Boolean.TRUE);
        keywords.put("while", Boolean.TRUE);
        keywords.put("foreach", Boolean.TRUE);
        keywords.put("&&", Boolean.TRUE);
        keywords.put("||", Boolean.TRUE);
        keywords.put("EOT", Boolean.TRUE);
        keywords.put("EOL", Boolean.TRUE);
        keywords.put("return", Boolean.TRUE);
        keywords.put("halt", Boolean.TRUE);
        keywords.put("done", Boolean.TRUE);
        keywords.put("break", Boolean.TRUE);
        keywords.put("continue", Boolean.TRUE);
        keywords.put("yield", Boolean.TRUE);
        keywords.put("throw", Boolean.TRUE);
        keywords.put("try", Boolean.TRUE);
        keywords.put("catch", Boolean.TRUE);
        keywords.put("assert", Boolean.TRUE);
    }
}

