/*
 * Decompiled with CFR 0.152.
 */
package sleep.error;

import java.io.File;
import sleep.runtime.ScriptInstance;

public class ScriptWarning {
    protected ScriptInstance script;
    protected String message;
    protected int line;
    protected boolean trace;
    protected String source;

    public ScriptWarning(ScriptInstance _script, String _message, int _line) {
        this(_script, _message, _line, false);
    }

    public ScriptWarning(ScriptInstance _script, String _message, int _line, boolean _trace) {
        this.script = _script;
        this.message = _message;
        this.line = _line;
        this.trace = _trace;
        this.source = this.script.getScriptEnvironment().getCurrentSource();
    }

    public boolean isDebugTrace() {
        return this.trace;
    }

    public ScriptInstance getSource() {
        return this.script;
    }

    public String toString() {
        if (this.isDebugTrace()) {
            return "Trace: " + this.getMessage() + " at " + this.getNameShort() + ":" + this.getLineNumber();
        }
        return "Warning: " + this.getMessage() + " at " + this.getNameShort() + ":" + this.getLineNumber();
    }

    public String getMessage() {
        return this.message;
    }

    public int getLineNumber() {
        return this.line;
    }

    public String getScriptName() {
        return this.source;
    }

    public String getNameShort() {
        return new File(this.getScriptName()).getName();
    }
}

