/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.types;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.SleepClosure;
import sleep.engine.types.HashContainer;
import sleep.runtime.CollectionWrapper;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.SleepUtils;

public class OrderedHashContainer
extends HashContainer {
    protected boolean shouldClean = false;
    protected SleepClosure missPolicy;
    protected SleepClosure removalPolicy;

    public OrderedHashContainer(int capacity, float loadfactor, boolean type) {
        this.values = new OrderedHash(capacity, loadfactor, type);
    }

    public void setRemovalPolicy(SleepClosure policy) {
        this.removalPolicy = policy;
    }

    public void setMissPolicy(SleepClosure policy) {
        this.missPolicy = policy;
    }

    protected boolean removeEldestEntryCheck(Map.Entry eldest) {
        if (this.removalPolicy != null && eldest != null) {
            Stack<Object> locals = new Stack<Object>();
            locals.push(eldest.getValue());
            locals.push(SleepUtils.getScalar(eldest.getKey().toString()));
            locals.push(SleepUtils.getHashScalar(this));
            Scalar value = this.removalPolicy.callClosure("remove", null, locals);
            return SleepUtils.isTrueScalar(value);
        }
        return false;
    }

    public ScalarArray keys() {
        LinkedList keys = new LinkedList();
        Iterator i = this.values.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry next = i.next();
            if (SleepUtils.isEmptyScalar((Scalar)next.getValue())) continue;
            keys.add(next.getKey());
        }
        this.shouldClean = this.values.size() > keys.size() + 1;
        return new CollectionWrapper(keys);
    }

    private void cleanup() {
        if (this.shouldClean) {
            Iterator i = this.values.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry next = i.next();
                if (!SleepUtils.isEmptyScalar((Scalar)next.getValue())) continue;
                i.remove();
            }
            this.shouldClean = false;
        }
    }

    public Scalar getAt(Scalar key) {
        String temp = ((Object)key.getValue()).toString();
        Scalar value = (Scalar)this.values.get(temp);
        if (this.missPolicy != null && SleepUtils.isEmptyScalar(value)) {
            this.cleanup();
            Stack<Scalar> locals = new Stack<Scalar>();
            locals.push(key);
            locals.push(SleepUtils.getHashScalar(this));
            value = this.missPolicy.callClosure("miss", null, locals);
            this.values.put(temp, value);
        } else if (value == null) {
            this.cleanup();
            value = SleepUtils.getEmptyScalar();
            this.values.put(temp, value);
        }
        return value;
    }

    private class OrderedHash
    extends LinkedHashMap {
        public OrderedHash(int c, float l, boolean b) {
            super(c, l, b);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return OrderedHashContainer.this.removeEldestEntryCheck(eldest);
        }
    }
}

