/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import sleep.runtime.SleepUtils;

public class MyLinkedList
extends AbstractSequentialList
implements Cloneable,
Serializable,
List {
    private transient int size = 0;
    private transient ListEntry header;
    private transient MyLinkedList parentList;

    public int size() {
        return this.size;
    }

    private MyLinkedList(MyLinkedList plist, ListEntry begin, ListEntry end, int _size) {
        this.parentList = plist;
        this.modCount = this.parentList.modCount;
        this.header = new SublistHeaderEntry(begin, end);
        this.size = _size;
    }

    public MyLinkedList() {
        this.header = new NormalListEntry(SleepUtils.getScalar("[:HEADER:]"), null, null);
        this.header.setNext(this.header);
        this.header.setPrevious(this.header);
    }

    public List subList(int beginAt, int endAt) {
        this.checkSafety();
        ListEntry begin = this.getAt(beginAt).next();
        ListEntry end = this.getAt(endAt);
        while (begin instanceof ListEntryWrapper) {
            begin = ((ListEntryWrapper)begin).parent;
        }
        while (end instanceof ListEntryWrapper) {
            end = ((ListEntryWrapper)end).parent;
        }
        return new MyLinkedList(this.parentList == null ? this : this.parentList, begin, end, endAt - beginAt);
    }

    public boolean add(Object o) {
        ListEntry entry = this.header;
        this.header.previous().addAfter(o);
        return true;
    }

    public void add(int index, Object element) {
        ListEntry entry = this.getAt(index);
        entry.addAfter(element);
    }

    public Object get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.getAt(index).next().element();
    }

    public Object remove(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        ListEntry entry = this.getAt(index).next();
        Object value = entry.element();
        entry.remove();
        return value;
    }

    private ListEntry getAt(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        ListEntry entry = this.header;
        if (index == this.size) {
            return this.header.previous();
        }
        if (index < this.size / 2) {
            for (int x = 0; x < index; ++x) {
                entry = entry.next();
            }
        } else {
            entry = entry.previous();
            for (int x = this.size; x > index; --x) {
                entry = entry.previous();
            }
        }
        return entry;
    }

    public ListIterator listIterator(int index) {
        return new MyListIterator(this.getAt(index), index);
    }

    public void checkSafety() {
        if (this.parentList != null && this.modCount != this.parentList.modCount) {
            throw new ConcurrentModificationException("parent @array changed after &sublist creation");
        }
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        Iterator i = this.iterator();
        while (i.hasNext()) {
            out.writeObject(i.next());
        }
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = in.readInt();
        this.header = new NormalListEntry(SleepUtils.getScalar("[:HEADER:]"), null, null);
        this.header.setNext(this.header);
        this.header.setPrevious(this.header);
        for (int x = 0; x < size; ++x) {
            this.add(in.readObject());
        }
    }

    private class NormalListEntry
    implements ListEntry {
        public Object element;
        public ListEntry previous;
        public ListEntry next;

        public NormalListEntry(Object _element, ListEntry _previous, ListEntry _next) {
            this.element = _element;
            this.previous = _previous;
            this.next = _next;
            if (this.previous != null) {
                this.previous.setNext(this);
            }
            if (this.next != null) {
                this.next.setPrevious(this);
            }
        }

        public void setNext(ListEntry entry) {
            this.next = entry;
        }

        public void setPrevious(ListEntry entry) {
            this.previous = entry;
        }

        public ListEntry next() {
            return this.next;
        }

        public ListEntry previous() {
            return this.previous;
        }

        public ListEntry remove() {
            ListEntry prev = this.previous();
            ListEntry nxt = this.next();
            nxt.setPrevious(prev);
            prev.setNext(nxt);
            MyLinkedList.this.size--;
            MyLinkedList.this.modCount++;
            return nxt;
        }

        public void setElement(Object o) {
            this.element = o;
        }

        public Object element() {
            return this.element;
        }

        public ListEntry addBefore(Object o) {
            NormalListEntry temp = new NormalListEntry(o, this.previous, this);
            MyLinkedList.this.size++;
            MyLinkedList.this.modCount++;
            return temp;
        }

        public ListEntry addAfter(Object o) {
            NormalListEntry temp = new NormalListEntry(o, this, this.next);
            MyLinkedList.this.size++;
            MyLinkedList.this.modCount++;
            return temp;
        }

        public String toString() {
            ListEntry entry;
            StringBuffer buffer = new StringBuffer(":[" + this.element() + "]:");
            if (this == MyLinkedList.this.header) {
                buffer = new StringBuffer(":[HEADER]:");
            }
            for (entry = this.previous(); entry != MyLinkedList.this.header; entry = entry.previous()) {
                buffer.insert(0, "[" + entry.element() + "]-> ");
            }
            for (entry = this.next(); entry != MyLinkedList.this.header; entry = entry.next()) {
                buffer.append(" ->[" + entry.element() + "]");
            }
            return buffer.toString();
        }
    }

    private class ListEntryWrapper
    implements ListEntry {
        public ListEntry parent;

        public ListEntryWrapper(ListEntry _parent) {
            this.parent = _parent;
        }

        public ListEntry remove() {
            MyLinkedList.this.checkSafety();
            ListEntry temp = this.parent.remove();
            MyLinkedList.this.size--;
            MyLinkedList.this.modCount++;
            if (MyLinkedList.this.size == 0) {
                return MyLinkedList.this.header;
            }
            if (this.parent == MyLinkedList.this.header.next()) {
                MyLinkedList.this.header.setNext(temp);
            }
            if (this.parent == MyLinkedList.this.header.previous()) {
                MyLinkedList.this.header.setPrevious(temp);
            }
            return new ListEntryWrapper(temp);
        }

        public ListEntry addBefore(Object o) {
            MyLinkedList.this.checkSafety();
            ListEntry temp = this.parent.addBefore(o);
            MyLinkedList.this.size++;
            MyLinkedList.this.modCount++;
            if (MyLinkedList.this.size == 1) {
                MyLinkedList.this.header.setNext(temp);
                MyLinkedList.this.header.setPrevious(temp);
            } else if (this.parent == MyLinkedList.this.header.next()) {
                MyLinkedList.this.header.setPrevious(temp);
            }
            return new ListEntryWrapper(temp);
        }

        public ListEntry addAfter(Object o) {
            MyLinkedList.this.checkSafety();
            ListEntry temp = this.parent.addAfter(o);
            MyLinkedList.this.size++;
            MyLinkedList.this.modCount++;
            if (MyLinkedList.this.size == 1) {
                MyLinkedList.this.header.setNext(temp);
                MyLinkedList.this.header.setPrevious(temp);
            } else if (this.parent == MyLinkedList.this.header.previous()) {
                MyLinkedList.this.header.setNext(temp);
            }
            return new ListEntryWrapper(temp);
        }

        public void setNext(ListEntry entry) {
            throw new UnsupportedOperationException("ListEntryWrapper::setNext");
        }

        public void setPrevious(ListEntry entry) {
            throw new UnsupportedOperationException("ListEntryWrapper::setPrevious");
        }

        public Object element() {
            return this.parent.element();
        }

        public void setElement(Object o) {
            this.parent.setElement(o);
        }

        public ListEntry next() {
            MyLinkedList.this.checkSafety();
            if (this.parent == MyLinkedList.this.header.next()) {
                return new ListEntryWrapper(MyLinkedList.this.header);
            }
            ListEntryWrapper r = new ListEntryWrapper(this.parent.next());
            return r;
        }

        public ListEntry previous() {
            MyLinkedList.this.checkSafety();
            if (this.parent == MyLinkedList.this.header.previous()) {
                return new ListEntryWrapper(MyLinkedList.this.header);
            }
            ListEntryWrapper r = new ListEntryWrapper(this.parent.previous());
            return r;
        }
    }

    private class SublistHeaderEntry
    implements ListEntry {
        private ListEntry anchorLeft;
        private ListEntry anchorRight;

        public SublistHeaderEntry(ListEntry a, ListEntry b) {
            this.anchorLeft = a.previous();
            this.anchorRight = b.next();
        }

        public ListEntry remove() {
            throw new UnsupportedOperationException("remove");
        }

        public ListEntry previous() {
            return new ListEntryWrapper(this.anchorRight.previous());
        }

        public ListEntry next() {
            return new ListEntryWrapper(this.anchorLeft.next());
        }

        public void setNext(ListEntry e) {
            this.anchorRight.setPrevious(e);
            e.setNext(this.anchorRight);
        }

        public void setPrevious(ListEntry e) {
            this.anchorLeft.setNext(e);
            e.setPrevious(this.anchorLeft);
        }

        public ListEntry addBefore(Object o) {
            return this.previous().addAfter(o);
        }

        public ListEntry addAfter(Object o) {
            return this.next().addBefore(o);
        }

        public Object element() {
            return SleepUtils.getScalar("[:header:]");
        }

        public void setElement(Object o) {
            throw new UnsupportedOperationException("setElement");
        }
    }

    private static interface ListEntry
    extends Serializable {
        public ListEntry remove();

        public ListEntry addBefore(Object var1);

        public ListEntry addAfter(Object var1);

        public ListEntry next();

        public ListEntry previous();

        public void setNext(ListEntry var1);

        public void setPrevious(ListEntry var1);

        public Object element();

        public void setElement(Object var1);
    }

    private class MyListIterator
    implements ListIterator,
    Serializable {
        protected int index;
        protected int start;
        protected ListEntry current;
        protected int modCountCheck;

        public void checkSafety() {
            if (this.modCountCheck != MyLinkedList.this.modCount) {
                throw new ConcurrentModificationException("@array changed during iteration");
            }
        }

        public MyListIterator(ListEntry entry, int index) {
            this.modCountCheck = MyLinkedList.this.modCount;
            this.index = index;
            this.start = index;
            this.current = entry;
        }

        public void add(Object o) {
            this.checkSafety();
            this.current = this.current.addAfter(o);
            ++this.index;
            ++this.modCountCheck;
        }

        public boolean hasNext() {
            return this.index != MyLinkedList.this.size;
        }

        public boolean hasPrevious() {
            return this.index != 0;
        }

        public Object next() {
            this.checkSafety();
            this.current = this.current.next();
            ++this.index;
            return this.current.element();
        }

        public Object previous() {
            this.checkSafety();
            this.current = this.current.previous();
            --this.index;
            return this.current.element();
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.current == MyLinkedList.this.header) {
                throw new IllegalStateException("list is empty");
            }
            this.checkSafety();
            this.current = this.current.remove().previous();
            --this.index;
            ++this.modCountCheck;
        }

        public void set(Object o) {
            if (this.current == MyLinkedList.this.header) {
                throw new IllegalStateException("list is empty");
            }
            this.checkSafety();
            this.current.setElement(o);
        }
    }
}

