/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.types;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import sleep.engine.types.MyLinkedList;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.SleepUtils;

public class ListContainer
implements ScalarArray {
    protected List values;

    public ListContainer() {
        this.values = new MyLinkedList();
    }

    public ListContainer(List list) {
        this.values = list;
    }

    public ScalarArray sublist(int from, int to) {
        return new ListContainer(this.values.subList(from, to));
    }

    public ListContainer(Collection initialValues) {
        this();
        this.values.addAll(initialValues);
    }

    public Scalar pop() {
        return (Scalar)this.values.remove(this.values.size() - 1);
    }

    public Scalar push(Scalar value) {
        this.values.add(value);
        return value;
    }

    public int size() {
        return this.values.size();
    }

    public void sort(Comparator compare) {
        Collections.sort(this.values, compare);
    }

    public Scalar getAt(int index) {
        if (index >= this.size()) {
            Scalar temp = SleepUtils.getEmptyScalar();
            this.values.add(temp);
            return temp;
        }
        return (Scalar)this.values.get(index);
    }

    public void remove(Scalar key) {
        SleepUtils.removeScalar(this.values.iterator(), key);
    }

    public Scalar remove(int index) {
        return (Scalar)this.values.remove(index);
    }

    public Iterator scalarIterator() {
        return this.values.iterator();
    }

    public Scalar add(Scalar value, int index) {
        this.values.add(index, value);
        return value;
    }

    public String toString() {
        return this.values.toString();
    }
}

