/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.types;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sleep.runtime.CollectionWrapper;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScalarType;
import sleep.runtime.SleepUtils;

public class HashContainer
implements ScalarHash {
    protected Map values;

    public HashContainer(Map container) {
        this.values = container;
    }

    public HashContainer() {
        this(new HashMap());
    }

    public Scalar getAt(Scalar key) {
        String temp = ((Object)key.getValue()).toString();
        Scalar value = (Scalar)this.values.get(temp);
        if (value == null) {
            value = SleepUtils.getEmptyScalar();
            this.values.put(temp, value);
        }
        return value;
    }

    public Map getData() {
        return this.values;
    }

    public ScalarArray keys() {
        ScalarType ntype = SleepUtils.getEmptyScalar().getValue();
        Iterator i = this.values.values().iterator();
        while (i.hasNext()) {
            Scalar next = (Scalar)i.next();
            if (next.getArray() != null || next.getHash() != null || next.getActualValue() != ntype) continue;
            i.remove();
        }
        return new CollectionWrapper(this.values.keySet());
    }

    public void remove(Scalar value) {
        SleepUtils.removeScalar(this.values.values().iterator(), value);
    }

    public String toString() {
        return this.values.toString();
    }
}

