/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import sleep.engine.Step;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class Return
extends Step {
    protected int return_type;

    public Return(int type) {
        this.return_type = type;
    }

    public String toString(String prefix) {
        return prefix + "[Return]: " + this.return_type + " \n";
    }

    public Scalar evaluate(ScriptEnvironment e) {
        if (this.return_type == 16) {
            Scalar temp = (Scalar)e.getCurrentFrame().pop();
            if (!SleepUtils.isEmptyScalar(temp)) {
                e.getScriptInstance().clearStackTrace();
                e.getScriptInstance().recordStackFrame("<origin of exception>", this.getLineNumber());
                e.flagReturn(temp, 16);
            }
        } else if (this.return_type == 2 || this.return_type == 4) {
            e.flagReturn(null, this.return_type);
        } else if (this.return_type == 72) {
            Scalar temp;
            Scalar scalar = temp = e.getCurrentFrame().isEmpty() ? SleepUtils.getEmptyScalar() : (Scalar)e.getCurrentFrame().pop();
            if (!SleepUtils.isFunctionScalar(temp)) {
                e.getScriptInstance().fireWarning("callcc requires a function: " + SleepUtils.describe(temp), this.getLineNumber());
                e.flagReturn(temp, 8);
            } else {
                e.flagReturn(temp, this.return_type);
            }
        } else if (e.getCurrentFrame().isEmpty()) {
            e.flagReturn(SleepUtils.getEmptyScalar(), this.return_type);
        } else {
            e.flagReturn((Scalar)e.getCurrentFrame().pop(), this.return_type);
        }
        e.KillFrame();
        return null;
    }
}

