/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import sleep.engine.Step;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class PLiteral
extends Step {
    public static final int STRING_FRAGMENT = 1;
    public static final int ALIGN_FRAGMENT = 2;
    public static final int VAR_FRAGMENT = 3;
    private List fragments;

    public String toString(String prefix) {
        StringBuffer temp = new StringBuffer();
        temp.append(prefix);
        temp.append("[Parsed Literal] ");
        Iterator i = this.fragments.iterator();
        while (i.hasNext()) {
            Fragment f = (Fragment)i.next();
            switch (f.type) {
                case 1: {
                    temp.append(f.element);
                    break;
                }
                case 2: {
                    temp.append("[:align:]");
                    break;
                }
                case 3: {
                    temp.append("[:var:]");
                }
            }
        }
        temp.append("\n");
        return temp.toString();
    }

    public Scalar evaluate(ScriptEnvironment e) {
        Scalar value = SleepUtils.getScalar(this.buildString(e));
        e.getCurrentFrame().push(value);
        return value;
    }

    public PLiteral(List f) {
        this.fragments = f;
    }

    public static Fragment fragment(int type, Object element) {
        Fragment f = new Fragment();
        f.element = element;
        f.type = type;
        return f;
    }

    private String buildString(ScriptEnvironment e) {
        StringBuffer result = new StringBuffer();
        int align = 0;
        Iterator i = this.fragments.iterator();
        while (i.hasNext()) {
            Fragment f = (Fragment)i.next();
            switch (f.type) {
                case 1: {
                    result.append(f.element);
                    break;
                }
                case 2: {
                    align = ((Scalar)e.getCurrentFrame().remove(0)).getValue().intValue();
                    break;
                }
                case 3: {
                    String temp = ((Object)((Scalar)e.getCurrentFrame().remove(0)).getValue()).toString();
                    for (int z = 0 - temp.length(); z > align; --z) {
                        result.append(" ");
                    }
                    result.append(temp);
                    for (int y = temp.length(); y < align; ++y) {
                        result.append(" ");
                    }
                    align = 0;
                }
            }
        }
        e.KillFrame();
        return result.toString();
    }

    private static final class Fragment
    implements Serializable {
        public Object element;
        public int type;

        private Fragment() {
        }
    }
}

