/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import sleep.engine.CallRequest;
import sleep.engine.ObjectUtilities;
import sleep.engine.Step;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class ObjectNew
extends Step {
    protected Class name;

    public ObjectNew(Class _name) {
        this.name = _name;
    }

    public String toString() {
        return "[Object New]: " + this.name + "\n";
    }

    public Scalar evaluate(ScriptEnvironment e) {
        Constructor theConstructor = ObjectUtilities.findConstructor(this.name, e.getCurrentFrame());
        if (theConstructor != null) {
            try {
                theConstructor.setAccessible(true);
            }
            catch (Exception ex) {
                // empty catch block
            }
            ConstructorCallRequest request = new ConstructorCallRequest(e, this.getLineNumber(), theConstructor, this.name);
            request.CallFunction();
            return null;
        }
        e.getScriptInstance().fireWarning("no constructor matching " + this.name.getName() + "(" + SleepUtils.describe(e.getCurrentFrame()) + ")", this.getLineNumber());
        Scalar result = SleepUtils.getEmptyScalar();
        e.FrameResult(result);
        return null;
    }

    private static class ConstructorCallRequest
    extends CallRequest {
        protected Constructor theConstructor;
        protected Class name;

        public ConstructorCallRequest(ScriptEnvironment e, int lineNo, Constructor cont, Class _name) {
            super(e, lineNo);
            this.theConstructor = cont;
            this.name = _name;
        }

        public String getFunctionName() {
            return this.name.toString();
        }

        public String getFrameDescription() {
            return this.name.toString();
        }

        public String formatCall(String args) {
            if (args != null && args.length() > 0) {
                args = ": " + args;
            }
            StringBuffer trace = new StringBuffer("[new " + this.name.getName() + args + "]");
            return trace.toString();
        }

        protected Scalar execute() {
            Object[] parameters = ObjectUtilities.buildArgumentArray(this.theConstructor.getParameterTypes(), this.getScriptEnvironment().getCurrentFrame(), this.getScriptEnvironment().getScriptInstance());
            try {
                return ObjectUtilities.BuildScalar(false, this.theConstructor.newInstance(parameters));
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() != null) {
                    this.getScriptEnvironment().flagError(ite.getCause());
                }
                throw new RuntimeException(ite);
            }
            catch (IllegalArgumentException aex) {
                aex.printStackTrace();
                this.getScriptEnvironment().getScriptInstance().fireWarning(ObjectUtilities.buildArgumentErrorMessage(this.name, this.name.getName(), this.theConstructor.getParameterTypes(), parameters), this.getLineNumber());
            }
            catch (InstantiationException iex) {
                this.getScriptEnvironment().getScriptInstance().fireWarning("unable to instantiate abstract class " + this.name.getName(), this.getLineNumber());
            }
            catch (IllegalAccessException iax) {
                this.getScriptEnvironment().getScriptInstance().fireWarning("cannot access constructor in " + this.name.getName() + ": " + iax.getMessage(), this.getLineNumber());
            }
            return SleepUtils.getEmptyScalar();
        }
    }
}

