/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import sleep.engine.CallRequest;
import sleep.engine.ObjectUtilities;
import sleep.engine.Step;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class ObjectAccess
extends Step {
    protected String name;
    protected Class classRef;

    public ObjectAccess(String _name, Class _classRef) {
        this.name = _name;
        this.classRef = _classRef;
    }

    public String toString() {
        return "[Object Access]: " + this.classRef + "#" + this.name + "\n";
    }

    public Scalar evaluate(ScriptEnvironment e) {
        Scalar result;
        block16: {
            Object accessMe = null;
            Class<?> theClass = null;
            Scalar scalar = null;
            if (this.classRef == null) {
                scalar = (Scalar)e.getCurrentFrame().pop();
                accessMe = scalar.objectValue();
                if (accessMe == null) {
                    e.getScriptInstance().fireWarning("Attempted to call a non-static method on a null reference", this.getLineNumber());
                    e.KillFrame();
                    e.getCurrentFrame().push(SleepUtils.getEmptyScalar());
                    return null;
                }
                theClass = accessMe.getClass();
            } else {
                theClass = this.classRef;
            }
            if (scalar != null && SleepUtils.isFunctionScalar(scalar)) {
                CallRequest.ClosureCallRequest request = new CallRequest.ClosureCallRequest(e, this.getLineNumber(), scalar, this.name);
                request.CallFunction();
                return null;
            }
            if (this.name == null) {
                e.getScriptInstance().fireWarning("Attempted to query an object with no method/field", this.getLineNumber());
                e.KillFrame();
                e.getCurrentFrame().push(SleepUtils.getEmptyScalar());
                return null;
            }
            result = SleepUtils.getEmptyScalar();
            Method theMethod = ObjectUtilities.findMethod(theClass, this.name, e.getCurrentFrame());
            if (theMethod != null && (this.classRef == null || (theMethod.getModifiers() & 8) == 8)) {
                try {
                    theMethod.setAccessible(true);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                MethodCallRequest request = new MethodCallRequest(e, this.getLineNumber(), theMethod, scalar, this.name, theClass);
                request.CallFunction();
                return null;
            }
            if (theMethod == null && !e.getCurrentFrame().isEmpty()) {
                e.getScriptInstance().fireWarning("there is no method that matches " + this.name + "(" + SleepUtils.describe(e.getCurrentFrame()) + ") in " + theClass.getName(), this.getLineNumber());
            } else {
                try {
                    Field aField = theClass.getField(this.name);
                    if (aField != null) {
                        try {
                            aField.setAccessible(true);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        result = ObjectUtilities.BuildScalar(true, aField.get(accessMe));
                        break block16;
                    }
                    result = SleepUtils.getEmptyScalar();
                }
                catch (NoSuchFieldException fex) {
                    e.getScriptInstance().fireWarning("no field/method named " + this.name + " in " + theClass, this.getLineNumber());
                }
                catch (IllegalAccessException iax) {
                    e.getScriptInstance().fireWarning("cannot access " + this.name + " in " + theClass + ": " + iax.getMessage(), this.getLineNumber());
                }
            }
        }
        e.FrameResult(result);
        return null;
    }

    private static class MethodCallRequest
    extends CallRequest {
        protected Method theMethod;
        protected Scalar scalar;
        protected String name;
        protected Class theClass;

        public MethodCallRequest(ScriptEnvironment e, int lineNo, Method method, Scalar _scalar, String _name, Class _class) {
            super(e, lineNo);
            this.theMethod = method;
            this.scalar = _scalar;
            this.name = _name;
            this.theClass = _class;
        }

        public String getFunctionName() {
            return this.theMethod.toString();
        }

        public String getFrameDescription() {
            return this.theMethod.toString();
        }

        public String formatCall(String args) {
            StringBuffer trace = new StringBuffer("[");
            if (args != null && args.length() > 0) {
                args = ": " + args;
            }
            if (this.scalar == null) {
                trace.append(this.theClass.getName() + " " + this.name + args + "]");
            } else if (Proxy.isProxyClass(this.theClass)) {
                trace.append(this.theClass.getName() + " " + this.name + args + "]");
            } else {
                trace.append(SleepUtils.describe(this.scalar) + " " + this.name + args + "]");
            }
            return trace.toString();
        }

        protected Scalar execute() {
            Object[] parameters = ObjectUtilities.buildArgumentArray(this.theMethod.getParameterTypes(), this.getScriptEnvironment().getCurrentFrame(), this.getScriptEnvironment().getScriptInstance());
            try {
                return ObjectUtilities.BuildScalar(true, this.theMethod.invoke(this.scalar != null ? this.scalar.objectValue() : null, parameters));
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() != null) {
                    this.getScriptEnvironment().flagError(ite.getCause());
                }
                throw new RuntimeException(ite);
            }
            catch (IllegalArgumentException aex) {
                aex.printStackTrace();
                this.getScriptEnvironment().getScriptInstance().fireWarning(ObjectUtilities.buildArgumentErrorMessage(this.theClass, this.name, this.theMethod.getParameterTypes(), parameters), this.getLineNumber());
            }
            catch (IllegalAccessException iax) {
                this.getScriptEnvironment().getScriptInstance().fireWarning("cannot access " + this.name + " in " + this.theClass + ": " + iax.getMessage(), this.getLineNumber());
            }
            return SleepUtils.getEmptyScalar();
        }
    }
}

