/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import sleep.engine.Step;
import sleep.interfaces.Variable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class Iterate
extends Step {
    public static final int ITERATOR_CREATE = 1;
    public static final int ITERATOR_DESTROY = 2;
    public static final int ITERATOR_NEXT = 3;
    protected int type = 0;
    protected String key;
    protected String value;

    public String toString(String prefix) {
        switch (this.type) {
            case 1: {
                return prefix + "[Create Iterator]\n";
            }
            case 2: {
                return prefix + "[Destroy Iterator]\n";
            }
            case 3: {
                return prefix + "[Iterator next]\n";
            }
        }
        return prefix + "[Iterator Unknown!@]";
    }

    public Iterate(String _key, String _value, int _type) {
        this.type = _type;
        this.key = _key;
        this.value = _value;
    }

    private void iterator_destroy(ScriptEnvironment e) {
        Stack iterators = (Stack)e.getContextMetadata("iterators");
        iterators.pop();
    }

    private void iterator_create(ScriptEnvironment e) {
        Stack temp = e.getCurrentFrame();
        IteratorData data = new IteratorData();
        data.source = (Scalar)temp.pop();
        e.KillFrame();
        data.value = this.value;
        data.venv = e.getScriptVariables().getScalarLevel(this.value, e.getScriptInstance());
        if (data.venv == null) {
            data.venv = e.getScriptVariables().getGlobalVariables();
        }
        if (this.key != null) {
            data.key = this.key;
            data.kenv = e.getScriptVariables().getScalarLevel(this.key, e.getScriptInstance());
            if (data.kenv == null) {
                data.kenv = e.getScriptVariables().getGlobalVariables();
            }
        }
        if (data.source.getHash() != null) {
            data.iterator = data.source.getHash().getData().entrySet().iterator();
        } else if (data.source.getArray() != null) {
            data.iterator = data.source.getArray().scalarIterator();
        } else if (SleepUtils.isFunctionScalar(data.source)) {
            data.iterator = SleepUtils.getFunctionFromScalar(data.source, e.getScriptInstance()).scalarIterator();
        } else {
            e.getScriptInstance().fireWarning("Attempted to use foreach on non-array: '" + data.source + "'", this.getLineNumber());
            data.iterator = null;
        }
        Stack<IteratorData> iterators = (Stack<IteratorData>)e.getContextMetadata("iterators");
        if (iterators == null) {
            iterators = new Stack<IteratorData>();
            e.setContextMetadata("iterators", iterators);
        }
        iterators.push(data);
    }

    private void iterator_next(ScriptEnvironment e) {
        Stack iterators = (Stack)e.getContextMetadata("iterators");
        IteratorData data = (IteratorData)iterators.peek();
        if (data.iterator == null || !data.iterator.hasNext()) {
            e.getCurrentFrame().push(SleepUtils.getScalar(false));
            return;
        }
        e.getCurrentFrame().push(SleepUtils.getScalar(true));
        Object next = null;
        try {
            next = data.iterator.next();
        }
        catch (ConcurrentModificationException cmex) {
            data.iterator = null;
            throw cmex;
        }
        if (data.source.getHash() != null) {
            if (data.key != null) {
                data.kenv.putScalar(data.key, SleepUtils.getScalar(((Map.Entry)next).getKey()));
                data.venv.putScalar(data.value, (Scalar)((Map.Entry)next).getValue());
            } else {
                data.venv.putScalar(data.value, SleepUtils.getScalar(((Map.Entry)next).getKey()));
            }
        } else if (data.key != null) {
            data.kenv.putScalar(data.key, SleepUtils.getScalar(data.count));
            data.venv.putScalar(data.value, next);
        } else {
            data.venv.putScalar(data.value, next);
        }
        ++data.count;
    }

    public Scalar evaluate(ScriptEnvironment e) {
        if (this.type == 3) {
            this.iterator_next(e);
        } else if (this.type == 1) {
            this.iterator_create(e);
        } else if (this.type == 2) {
            this.iterator_destroy(e);
        }
        return null;
    }

    public static class IteratorData {
        public String key = null;
        public Variable kenv = null;
        public String value = null;
        public Variable venv = null;
        public Scalar source = null;
        public Iterator iterator = null;
        public int count = 0;
    }
}

