/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import sleep.bridges.SleepClosure;
import sleep.engine.Block;
import sleep.engine.Step;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class Index
extends Step {
    String value;
    Block index;

    public String toString(String prefix) {
        StringBuffer temp = new StringBuffer();
        temp.append(prefix);
        temp.append("[Scalar index]: " + this.value + "\n");
        if (this.index != null) {
            temp.append(this.index.toString(prefix + "   "));
        }
        return temp.toString();
    }

    public Index(String v, Block i) {
        this.value = v;
        this.index = i;
    }

    public Scalar evaluate(ScriptEnvironment e) {
        Scalar rv = null;
        Scalar structure = (Scalar)e.getCurrentFrame().pop();
        if (SleepUtils.isEmptyScalar(structure)) {
            if (this.value.charAt(0) == '@') {
                structure.setValue(SleepUtils.getArrayScalar());
            } else if (this.value.charAt(0) == '%') {
                structure.setValue(SleepUtils.getHashScalar());
            }
        }
        this.index.evaluate(e);
        Scalar pos = (Scalar)e.getCurrentFrame().pop();
        if (structure.getArray() != null) {
            int posv = pos.getValue().intValue();
            if (posv < 0) {
                int size = structure.getArray().size();
                while (posv < 0) {
                    posv += size;
                }
            }
            rv = structure.getArray().getAt(posv);
        } else if (structure.getHash() != null) {
            rv = structure.getHash().getAt(pos);
        } else if (structure.objectValue() != null && structure.objectValue() instanceof SleepClosure) {
            SleepClosure closure = (SleepClosure)structure.objectValue();
            if (!closure.getVariables().scalarExists(pos.toString())) {
                closure.getVariables().putScalar(pos.toString(), SleepUtils.getEmptyScalar());
            }
            rv = closure.getVariables().getScalar(pos.toString());
        } else {
            e.KillFrame();
            throw new IllegalArgumentException("invalid use of index operator: " + SleepUtils.describe(structure) + "[" + SleepUtils.describe(pos) + "]");
        }
        e.FrameResult(rv);
        return null;
    }
}

