/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import sleep.engine.Block;
import sleep.engine.Step;
import sleep.engine.atoms.Check;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;

public class Decide
extends Step {
    public Block iftrue;
    public Block iffalse;
    public Check start;

    public Decide(Check s) {
        this.start = s;
    }

    public String toString(String prefix) {
        StringBuffer temp = new StringBuffer();
        temp.append(prefix);
        temp.append("[Decide]:\n");
        temp.append(prefix);
        temp.append("  [Condition]: \n");
        temp.append(this.start.toString(prefix + "      "));
        if (this.iftrue != null) {
            temp.append(prefix);
            temp.append("  [If true]:   \n");
            temp.append(this.iftrue.toString(prefix + "      "));
        }
        if (this.iffalse != null) {
            temp.append(prefix);
            temp.append("  [If False]:   \n");
            temp.append(this.iffalse.toString(prefix + "      "));
        }
        return temp.toString();
    }

    public int getHighLineNumber() {
        int y;
        if (this.iftrue == null) {
            return this.iffalse.getHighLineNumber();
        }
        if (this.iffalse == null) {
            return this.iftrue.getHighLineNumber();
        }
        int x = this.iftrue.getHighLineNumber();
        return x > (y = this.iffalse.getHighLineNumber()) ? x : y;
    }

    public void setChoices(Block t, Block f) {
        this.iftrue = t;
        this.iffalse = f;
    }

    public Scalar evaluate(ScriptEnvironment e) {
        if (this.start.check(e)) {
            if (this.iftrue != null) {
                this.iftrue.evaluate(e);
            }
        } else if (this.iffalse != null) {
            this.iffalse.evaluate(e);
        }
        return null;
    }
}

